/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.context;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.convert.ConversionService;
import org.springframework.integration.context.IntegrationContextUtils;
import org.springframework.integration.context.NamedComponent;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class IntegrationObjectSupport
implements BeanNameAware,
NamedComponent,
BeanFactoryAware,
InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private volatile String beanName;
    private volatile String componentName;
    private volatile BeanFactory beanFactory;
    private volatile TaskScheduler taskScheduler;
    private volatile ConversionService conversionService;

    public final void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public final String getComponentName() {
        return StringUtils.hasText((String)this.componentName) ? this.componentName : this.beanName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public String getComponentType() {
        return null;
    }

    public final void setBeanFactory(BeanFactory beanFactory) {
        Assert.notNull((Object)beanFactory, (String)"beanFactory must not be null");
        this.beanFactory = beanFactory;
    }

    public final void afterPropertiesSet() {
        try {
            this.onInit();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new BeanInitializationException("failed to initialize", (Throwable)e);
        }
    }

    protected void onInit() throws Exception {
    }

    protected final BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    protected TaskScheduler getTaskScheduler() {
        if (this.taskScheduler == null && this.beanFactory != null) {
            this.taskScheduler = IntegrationContextUtils.getTaskScheduler(this.beanFactory);
        }
        return this.taskScheduler;
    }

    protected void setTaskScheduler(TaskScheduler taskScheduler) {
        Assert.notNull((Object)taskScheduler, (String)"taskScheduler must not be null");
        this.taskScheduler = taskScheduler;
    }

    protected final ConversionService getConversionService() {
        if (this.conversionService == null && this.beanFactory != null) {
            this.conversionService = IntegrationContextUtils.getConversionService(this.beanFactory);
            if (this.conversionService == null && this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Unable to attempt conversion of Message payload types. Component '" + this.getComponentName() + "' has no explicit ConversionService reference, " + "and there is no 'integrationConversionService' bean within the context."));
            }
        }
        return this.conversionService;
    }

    protected void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public String toString() {
        return this.beanName != null ? this.beanName : super.toString();
    }
}

