/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.core;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.Message;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.MessageDeliveryException;
import org.springframework.integration.MessagingException;
import org.springframework.integration.core.MessagePostProcessor;
import org.springframework.integration.core.MessagingOperations;
import org.springframework.integration.core.PollableChannel;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.integration.support.channel.BeanFactoryChannelResolver;
import org.springframework.integration.support.channel.ChannelResolver;
import org.springframework.integration.support.converter.MessageConverter;
import org.springframework.integration.support.converter.SimpleMessageConverter;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessagingTemplate
implements MessagingOperations,
BeanFactoryAware,
InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private volatile MessageChannel defaultChannel;
    private volatile ChannelResolver channelResolver;
    private volatile MessageConverter messageConverter = new SimpleMessageConverter();
    private volatile long sendTimeout = -1L;
    private volatile long receiveTimeout = -1L;
    private volatile boolean initialized;
    private final Object initializationMonitor = new Object();

    public MessagingTemplate() {
    }

    public MessagingTemplate(MessageChannel defaultChannel) {
        this.defaultChannel = defaultChannel;
    }

    public void setDefaultChannel(MessageChannel defaultChannel) {
        this.defaultChannel = defaultChannel;
    }

    public void setChannelResolver(ChannelResolver channelResolver) {
        Assert.notNull((Object)channelResolver, (String)"'channelResolver' must not be null");
        this.channelResolver = channelResolver;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        Assert.notNull((Object)messageConverter, (String)"'messageConverter' must not be null");
        this.messageConverter = messageConverter;
    }

    public void setSendTimeout(long sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    public void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        if (this.channelResolver == null && beanFactory != null) {
            this.channelResolver = new BeanFactoryChannelResolver(beanFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() {
        Object object = this.initializationMonitor;
        synchronized (object) {
            if (this.initialized) {
                return;
            }
            this.initialized = true;
        }
    }

    @Override
    public <P> void send(Message<P> message) {
        this.send(this.getRequiredDefaultChannel(), message);
    }

    @Override
    public <P> void send(MessageChannel channel, Message<P> message) {
        this.doSend(channel, message);
    }

    @Override
    public <P> void send(String channelName, Message<P> message) {
        this.send(this.resolveChannelName(channelName), message);
    }

    @Override
    public <T> void convertAndSend(T object) {
        Message message = this.messageConverter.toMessage(object);
        if (message != null) {
            this.send(message);
        }
    }

    @Override
    public <T> void convertAndSend(MessageChannel channel, T object) {
        Message message = this.messageConverter.toMessage(object);
        if (message != null) {
            this.send(channel, message);
        }
    }

    @Override
    public <T> void convertAndSend(String channelName, T object) {
        Message message = this.messageConverter.toMessage(object);
        if (message != null) {
            this.send(channelName, message);
        }
    }

    @Override
    public <T> void convertAndSend(T object, MessagePostProcessor postProcessor) {
        Message<Object> message = this.messageConverter.toMessage(object);
        if ((message = postProcessor.postProcessMessage(message)) != null) {
            this.send(message);
        }
    }

    @Override
    public <T> void convertAndSend(MessageChannel channel, T object, MessagePostProcessor postProcessor) {
        Message<Object> message = this.messageConverter.toMessage(object);
        if ((message = postProcessor.postProcessMessage(message)) != null) {
            this.send(channel, message);
        }
    }

    @Override
    public <T> void convertAndSend(String channelName, T object, MessagePostProcessor postProcessor) {
        Message<Object> message = this.messageConverter.toMessage(object);
        if ((message = postProcessor.postProcessMessage(message)) != null) {
            this.send(channelName, message);
        }
    }

    @Override
    public <P> Message<P> receive() {
        MessageChannel channel = this.getRequiredDefaultChannel();
        Assert.state((boolean)(channel instanceof PollableChannel), (String)"The 'defaultChannel' must be a PollableChannel for receive operations.");
        return this.receive((PollableChannel)channel);
    }

    @Override
    public <P> Message<P> receive(PollableChannel channel) {
        return this.doReceive(channel);
    }

    @Override
    public <P> Message<P> receive(String channelName) {
        MessageChannel channel = this.resolveChannelName(channelName);
        Assert.isInstanceOf(PollableChannel.class, (Object)channel, (String)"A PollableChannel is required for receive operations. ");
        return this.receive((PollableChannel)channel);
    }

    @Override
    public Object receiveAndConvert() throws MessagingException {
        Message message = this.receive();
        return message != null ? this.messageConverter.fromMessage(message) : null;
    }

    @Override
    public Object receiveAndConvert(PollableChannel channel) throws MessagingException {
        Message message = this.receive(channel);
        return message != null ? this.messageConverter.fromMessage(message) : null;
    }

    @Override
    public Object receiveAndConvert(String channelName) throws MessagingException {
        Message message = this.receive(channelName);
        return message != null ? this.messageConverter.fromMessage(message) : null;
    }

    @Override
    public Message<?> sendAndReceive(Message<?> requestMessage) {
        return this.sendAndReceive(this.getRequiredDefaultChannel(), requestMessage);
    }

    @Override
    public Message<?> sendAndReceive(MessageChannel channel, Message<?> requestMessage) {
        return this.doSendAndReceive(channel, requestMessage);
    }

    @Override
    public Message<?> sendAndReceive(String channelName, Message<?> requestMessage) {
        return this.sendAndReceive(this.resolveChannelName(channelName), requestMessage);
    }

    @Override
    public Object convertSendAndReceive(Object request) {
        Message requestMessage = this.messageConverter.toMessage(request);
        Message<?> replyMessage = this.sendAndReceive(requestMessage);
        return this.messageConverter.fromMessage(replyMessage);
    }

    @Override
    public Object convertSendAndReceive(MessageChannel channel, Object request) {
        Message requestMessage = this.messageConverter.toMessage(request);
        Message<?> replyMessage = this.sendAndReceive(channel, requestMessage);
        return this.messageConverter.fromMessage(replyMessage);
    }

    @Override
    public Object convertSendAndReceive(String channelName, Object request) {
        Message requestMessage = this.messageConverter.toMessage(request);
        Message<?> replyMessage = this.sendAndReceive(channelName, requestMessage);
        return this.messageConverter.fromMessage(replyMessage);
    }

    @Override
    public Object convertSendAndReceive(Object request, MessagePostProcessor requestPostProcessor) {
        Message<Object> requestMessage = this.messageConverter.toMessage(request);
        requestMessage = requestPostProcessor.postProcessMessage(requestMessage);
        Message<?> replyMessage = this.sendAndReceive(requestMessage);
        return this.messageConverter.fromMessage(replyMessage);
    }

    @Override
    public Object convertSendAndReceive(MessageChannel channel, Object request, MessagePostProcessor requestPostProcessor) {
        Message<Object> requestMessage = this.messageConverter.toMessage(request);
        requestMessage = requestPostProcessor.postProcessMessage(requestMessage);
        Message<?> replyMessage = this.sendAndReceive(channel, requestMessage);
        return this.messageConverter.fromMessage(replyMessage);
    }

    @Override
    public Object convertSendAndReceive(String channelName, Object request, MessagePostProcessor requestPostProcessor) {
        Message<Object> requestMessage = this.messageConverter.toMessage(request);
        requestMessage = requestPostProcessor.postProcessMessage(requestMessage);
        Message<?> replyMessage = this.sendAndReceive(channelName, requestMessage);
        return this.messageConverter.fromMessage(replyMessage);
    }

    private void doSend(MessageChannel channel, Message<?> message) {
        boolean sent;
        Assert.notNull((Object)channel, (String)"channel must not be null");
        long timeout = this.sendTimeout;
        boolean bl = sent = timeout >= 0L ? channel.send(message, timeout) : channel.send(message);
        if (!sent) {
            throw new MessageDeliveryException(message, "failed to send message to channel '" + channel + "' within timeout: " + timeout);
        }
    }

    private <P> Message<P> doReceive(PollableChannel channel) {
        Message<?> message;
        Assert.notNull((Object)channel, (String)"channel must not be null");
        long timeout = this.receiveTimeout;
        Message<?> message2 = message = timeout >= 0L ? channel.receive(timeout) : channel.receive();
        if (message == null && this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("failed to receive message from channel '" + channel + "' within timeout: " + timeout));
        }
        return message;
    }

    private <S, R> Message<R> doSendAndReceive(MessageChannel channel, Message<S> requestMessage) {
        Object originalReplyChannelHeader = requestMessage.getHeaders().getReplyChannel();
        Object originalErrorChannelHeader = requestMessage.getHeaders().getErrorChannel();
        TemporaryReplyChannel replyChannel = new TemporaryReplyChannel(this.receiveTimeout);
        requestMessage = MessageBuilder.fromMessage(requestMessage).setReplyChannel(replyChannel).setErrorChannel(replyChannel).build();
        this.doSend(channel, requestMessage);
        Message reply = this.doReceive(replyChannel);
        if (reply != null) {
            reply = MessageBuilder.fromMessage(reply).setHeader("replyChannel", originalReplyChannelHeader).setHeader("errorChannel", originalErrorChannelHeader).build();
        }
        return reply;
    }

    private MessageChannel getRequiredDefaultChannel() {
        Assert.state((this.defaultChannel != null ? 1 : 0) != 0, (String)"No 'defaultChannel' specified for MessagingTemplate. Unable to invoke methods without an explicit channel argument.");
        return this.defaultChannel;
    }

    private ChannelResolver getRequiredChannelResolver() {
        Assert.state((this.channelResolver != null ? 1 : 0) != 0, (String)"No 'channelResolver' specified for MessagingTemplate. Unable to invoke methods with a channel name argument.");
        return this.channelResolver;
    }

    protected MessageChannel resolveChannelName(String channelName) {
        return this.getRequiredChannelResolver().resolveChannelName(channelName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TemporaryReplyChannel
    implements PollableChannel {
        private volatile Message<?> message;
        private final long receiveTimeout;
        private final CountDownLatch latch = new CountDownLatch(1);

        public TemporaryReplyChannel(long receiveTimeout) {
            this.receiveTimeout = receiveTimeout;
        }

        @Override
        public Message<?> receive() {
            return this.receive(-1L);
        }

        @Override
        public Message<?> receive(long timeout) {
            try {
                if (this.receiveTimeout < 0L) {
                    this.latch.await();
                } else {
                    this.latch.await(this.receiveTimeout, TimeUnit.MILLISECONDS);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return this.message;
        }

        @Override
        public boolean send(Message<?> message) {
            return this.send(message, -1L);
        }

        @Override
        public boolean send(Message<?> message, long timeout) {
            this.message = message;
            this.latch.countDown();
            return true;
        }
    }
}

