/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dispatcher;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.core.MessageHandler;
import org.springframework.integration.dispatcher.MessageDispatcher;
import org.springframework.integration.dispatcher.OrderedAwareLinkedHashSet;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDispatcher
implements MessageDispatcher {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Set<MessageHandler> handlers = new OrderedAwareLinkedHashSet<MessageHandler>();

    protected List<MessageHandler> getHandlers() {
        return Collections.unmodifiableList(Arrays.asList(this.handlers.toArray(new MessageHandler[this.handlers.size()])));
    }

    @Override
    public boolean addHandler(MessageHandler handler) {
        Assert.notNull((Object)handler, (String)"handler must not be null");
        return this.handlers.add(handler);
    }

    @Override
    public boolean removeHandler(MessageHandler handler) {
        Assert.notNull((Object)handler, (String)"handler must not be null");
        return this.handlers.remove(handler);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " with handlers: " + this.handlers.toString();
    }

    public int getHandlerCount() {
        return this.handlers.size();
    }
}

