/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dispatcher;

import java.util.List;
import java.util.concurrent.Executor;
import org.springframework.integration.Message;
import org.springframework.integration.MessageDispatchingException;
import org.springframework.integration.MessagingException;
import org.springframework.integration.core.MessageHandler;
import org.springframework.integration.dispatcher.AbstractDispatcher;
import org.springframework.integration.support.MessageBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BroadcastingDispatcher
extends AbstractDispatcher {
    private final boolean requireSubscribers;
    private volatile boolean ignoreFailures;
    private volatile boolean applySequence;
    private final Executor executor;

    public BroadcastingDispatcher() {
        this(null, false);
    }

    public BroadcastingDispatcher(Executor executor) {
        this(executor, false);
    }

    public BroadcastingDispatcher(boolean requireSubscribers) {
        this(null, requireSubscribers);
    }

    public BroadcastingDispatcher(Executor executor, boolean requireSubscribers) {
        this.requireSubscribers = requireSubscribers;
        this.executor = executor;
    }

    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures = ignoreFailures;
    }

    public void setApplySequence(boolean applySequence) {
        this.applySequence = applySequence;
    }

    @Override
    public boolean dispatch(Message<?> message) {
        boolean dispatched = false;
        int sequenceNumber = 1;
        List<MessageHandler> handlers = this.getHandlers();
        if (this.requireSubscribers && handlers.size() == 0) {
            throw new MessageDispatchingException(message, "Dispatcher has no subscribers");
        }
        int sequenceSize = handlers.size();
        for (final MessageHandler handler : handlers) {
            Message<?> messageToSend;
            Message<?> message2 = messageToSend = !this.applySequence ? message : MessageBuilder.fromMessage(message).pushSequenceDetails(message.getHeaders().getId(), sequenceNumber++, sequenceSize).build();
            if (this.executor != null) {
                this.executor.execute(new Runnable(){

                    public void run() {
                        BroadcastingDispatcher.this.invokeHandler(handler, messageToSend);
                    }
                });
                dispatched = true;
                continue;
            }
            boolean success = this.invokeHandler(handler, messageToSend);
            dispatched = success || dispatched;
        }
        return dispatched;
    }

    private boolean invokeHandler(MessageHandler handler, Message<?> message) {
        try {
            handler.handleMessage(message);
            return true;
        }
        catch (RuntimeException e) {
            if (!this.ignoreFailures) {
                if (e instanceof MessagingException && ((MessagingException)e).getFailedMessage() == null) {
                    ((MessagingException)e).setFailedMessage(message);
                }
                throw e;
            }
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)"Suppressing Exception since 'ignoreFailures' is set to TRUE.", (Throwable)e);
            }
            return false;
        }
    }
}

