/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dispatcher;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.springframework.core.OrderComparator;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OrderedAwareLinkedHashSet<E>
extends LinkedHashSet<E> {
    private final OrderComparator comparator = new OrderComparator();
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.rwl.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.rwl.writeLock();

    OrderedAwareLinkedHashSet() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E o) {
        Assert.notNull(o, (String)"Can not add NULL object");
        this.writeLock.lock();
        try {
            boolean present = false;
            present = o instanceof Ordered ? this.addOrderedElement((Ordered)o) : super.add(o);
            boolean bl = present;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends E> c) {
        Assert.notNull(c, (String)"Can not merge with NULL set");
        this.writeLock.lock();
        try {
            for (E object : c) {
                this.add(object);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        this.writeLock.lock();
        try {
            boolean bl = super.remove(o);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        if (CollectionUtils.isEmpty(c)) {
            return false;
        }
        this.writeLock.lock();
        try {
            boolean bl = super.removeAll(c);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        this.readLock.lock();
        try {
            T[] TArray = super.toArray(a);
            return TArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        this.readLock.lock();
        try {
            String string = StringUtils.collectionToCommaDelimitedString((Collection)this);
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private boolean addOrderedElement(Ordered adding) {
        boolean added = false;
        Object[] tempUnorderedElements = this.toArray();
        if (super.contains(adding)) {
            return false;
        }
        super.clear();
        if (tempUnorderedElements.length == 0) {
            added = super.add(adding);
        } else {
            LinkedHashSet<Object> tempSet = new LinkedHashSet<Object>();
            for (Object current : tempUnorderedElements) {
                if (current instanceof Ordered) {
                    if (this.comparator.compare((Object)adding, current) < 0) {
                        added = super.add(adding);
                        super.add(current);
                        continue;
                    }
                    super.add(current);
                    continue;
                }
                tempSet.add(current);
            }
            if (!added) {
                added = super.add(adding);
            }
            for (Object e : tempSet) {
                super.add(e);
            }
        }
        return added;
    }
}

