/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dispatcher;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.integration.Message;
import org.springframework.integration.core.MessageHandler;
import org.springframework.integration.dispatcher.LoadBalancingStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoundRobinLoadBalancingStrategy
implements LoadBalancingStrategy {
    private final AtomicInteger currentHandlerIndex = new AtomicInteger();

    @Override
    public final Iterator<MessageHandler> getHandlerIterator(Message<?> message, List<MessageHandler> handlers) {
        int size = handlers.size();
        if (size == 0) {
            return handlers.iterator();
        }
        int nextHandlerStartIndex = this.getNextHandlerStartIndex(size);
        ArrayList<MessageHandler> reorderedHandlers = new ArrayList<MessageHandler>(handlers.subList(nextHandlerStartIndex, size));
        reorderedHandlers.addAll(handlers.subList(0, nextHandlerStartIndex));
        return reorderedHandlers.iterator();
    }

    private int getNextHandlerStartIndex(int size) {
        int indexTail = this.currentHandlerIndex.getAndIncrement() % size;
        return indexTail < 0 ? indexTail + size : indexTail;
    }
}

