/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.endpoint;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import org.aopalliance.aop.Advice;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.integration.MessageHandlingException;
import org.springframework.integration.MessagingException;
import org.springframework.integration.channel.MessagePublishingErrorHandler;
import org.springframework.integration.endpoint.AbstractEndpoint;
import org.springframework.integration.message.ErrorMessage;
import org.springframework.integration.scheduling.PollerMetadata;
import org.springframework.integration.support.channel.BeanFactoryChannelResolver;
import org.springframework.integration.util.ErrorHandlingTaskExecutor;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.PeriodicTrigger;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ErrorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPollingEndpoint
extends AbstractEndpoint
implements BeanClassLoaderAware {
    private volatile Executor taskExecutor = new SyncTaskExecutor();
    private volatile ErrorHandler errorHandler;
    private volatile Trigger trigger = new PeriodicTrigger(10L);
    private volatile List<Advice> adviceChain;
    private volatile ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private volatile ScheduledFuture<?> runningTask;
    private volatile Runnable poller;
    private volatile boolean initialized;
    private volatile long maxMessagesPerPoll = -1L;
    private final Object initializationMonitor = new Object();

    public AbstractPollingEndpoint() {
        this.setPhase(Integer.MAX_VALUE);
    }

    @Deprecated
    public void setPollerMetadata(PollerMetadata pollerMetadata) {
        Assert.notNull((Object)pollerMetadata, (String)"'pollerMetadata' must not be null.");
        this.setAdviceChain(pollerMetadata.getAdviceChain());
        this.setMaxMessagesPerPoll(pollerMetadata.getMaxMessagesPerPoll());
        this.setTaskExecutor(pollerMetadata.getTaskExecutor());
        this.setTrigger(pollerMetadata.getTrigger());
    }

    public void setTaskExecutor(Executor taskExecutor) {
        this.taskExecutor = taskExecutor != null ? taskExecutor : new SyncTaskExecutor();
    }

    public void setTrigger(Trigger trigger) {
        this.trigger = trigger != null ? trigger : new PeriodicTrigger(10L);
    }

    public void setAdviceChain(List<Advice> adviceChain) {
        this.adviceChain = adviceChain;
    }

    public void setMaxMessagesPerPoll(long maxMessagesPerPoll) {
        this.maxMessagesPerPoll = maxMessagesPerPoll;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onInit() {
        Object object = this.initializationMonitor;
        synchronized (object) {
            if (this.initialized) {
                return;
            }
            Assert.notNull((Object)this.trigger, (String)"Trigger is required");
            Executor providedExecutor = this.taskExecutor;
            if (providedExecutor != null) {
                this.taskExecutor = providedExecutor;
            }
            if (this.taskExecutor != null && !(this.taskExecutor instanceof ErrorHandlingTaskExecutor)) {
                if (this.errorHandler == null) {
                    Assert.notNull((Object)this.getBeanFactory(), (String)"BeanFactory is required");
                    this.errorHandler = new MessagePublishingErrorHandler(new BeanFactoryChannelResolver(this.getBeanFactory()));
                }
                this.taskExecutor = new ErrorHandlingTaskExecutor(this.taskExecutor, this.errorHandler);
            }
            try {
                this.poller = this.createPoller();
                this.initialized = true;
            }
            catch (Exception e) {
                throw new MessagingException("Failed to create Poller", (Throwable)e);
            }
        }
    }

    private Runnable createPoller() throws Exception {
        Callable<Boolean> pollingTask = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return AbstractPollingEndpoint.this.doPoll();
            }
        };
        List<Advice> adviceChain = this.adviceChain;
        if (!CollectionUtils.isEmpty(adviceChain)) {
            ProxyFactory proxyFactory = new ProxyFactory((Object)pollingTask);
            if (!CollectionUtils.isEmpty(adviceChain)) {
                for (Advice advice : adviceChain) {
                    proxyFactory.addAdvice(advice);
                }
            }
            pollingTask = (Callable)proxyFactory.getProxy(this.beanClassLoader);
        }
        return new Poller(pollingTask);
    }

    @Override
    protected void doStart() {
        if (!this.initialized) {
            this.onInit();
        }
        Assert.state((this.getTaskScheduler() != null ? 1 : 0) != 0, (String)"unable to start polling, no taskScheduler available");
        this.runningTask = this.getTaskScheduler().schedule(this.poller, this.trigger);
    }

    @Override
    protected void doStop() {
        if (this.runningTask != null) {
            this.runningTask.cancel(true);
        }
        this.runningTask = null;
        this.initialized = false;
    }

    protected abstract boolean doPoll();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Poller
    implements Runnable {
        private final Callable<Boolean> pollingTask;

        public Poller(Callable<Boolean> pollingTask) {
            this.pollingTask = pollingTask;
        }

        @Override
        public void run() {
            AbstractPollingEndpoint.this.taskExecutor.execute(new Runnable(){

                public void run() {
                    int count = 0;
                    while (AbstractPollingEndpoint.this.initialized && (AbstractPollingEndpoint.this.maxMessagesPerPoll <= 0L || (long)count < AbstractPollingEndpoint.this.maxMessagesPerPoll)) {
                        try {
                            if (!((Boolean)Poller.this.pollingTask.call()).booleanValue()) break;
                            ++count;
                        }
                        catch (Exception e) {
                            if (e instanceof RuntimeException) {
                                throw (RuntimeException)e;
                            }
                            throw new MessageHandlingException(new ErrorMessage(e));
                        }
                    }
                }
            });
        }
    }
}

