/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.endpoint;

import org.springframework.integration.context.NamedComponent;
import org.springframework.integration.core.MessageHandler;
import org.springframework.integration.core.SubscribableChannel;
import org.springframework.integration.endpoint.AbstractEndpoint;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class EventDrivenConsumer
extends AbstractEndpoint {
    private final SubscribableChannel inputChannel;
    private final MessageHandler handler;

    public EventDrivenConsumer(SubscribableChannel inputChannel, MessageHandler handler) {
        Assert.notNull((Object)inputChannel, (String)"inputChannel must not be null");
        Assert.notNull((Object)handler, (String)"handler must not be null");
        this.inputChannel = inputChannel;
        this.handler = handler;
        this.setPhase(Integer.MIN_VALUE);
    }

    protected void doStart() {
        this.logComponentSubscriptionEvent(true);
        this.inputChannel.subscribe(this.handler);
    }

    protected void doStop() {
        this.logComponentSubscriptionEvent(false);
        this.inputChannel.unsubscribe(this.handler);
    }

    private void logComponentSubscriptionEvent(boolean add) {
        if (this.handler instanceof NamedComponent && this.inputChannel instanceof NamedComponent) {
            String channelName = ((NamedComponent)((Object)this.inputChannel)).getComponentName();
            String componentType = ((NamedComponent)((Object)this.handler)).getComponentType();
            componentType = StringUtils.hasText((String)componentType) ? componentType : "";
            String componentName = this.getComponentName();
            componentName = StringUtils.hasText((String)componentName) && componentName.contains("#") ? "" : ":" + componentName;
            StringBuffer buffer = new StringBuffer();
            buffer.append("{" + componentType + componentName + "} as a subscriber to the '" + channelName + "' channel");
            if (add) {
                buffer.insert(0, "Adding ");
            } else {
                buffer.insert(0, "Removing ");
            }
            this.logger.info((Object)buffer.toString());
        }
    }
}

