/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.endpoint;

import org.springframework.integration.Message;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.MessageDeliveryException;
import org.springframework.integration.MessagingException;
import org.springframework.integration.core.MessageProducer;
import org.springframework.integration.core.MessagingTemplate;
import org.springframework.integration.endpoint.AbstractEndpoint;
import org.springframework.integration.history.MessageHistory;
import org.springframework.integration.history.TrackableComponent;
import org.springframework.integration.message.ErrorMessage;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MessageProducerSupport
extends AbstractEndpoint
implements MessageProducer,
TrackableComponent {
    private volatile MessageChannel outputChannel;
    private volatile MessageChannel errorChannel;
    private volatile boolean shouldTrack = false;
    private final MessagingTemplate messagingTemplate = new MessagingTemplate();

    @Override
    public void setOutputChannel(MessageChannel outputChannel) {
        this.outputChannel = outputChannel;
    }

    public void setErrorChannel(MessageChannel errorChannel) {
        this.errorChannel = errorChannel;
    }

    public void setSendTimeout(long sendTimeout) {
        this.messagingTemplate.setSendTimeout(sendTimeout);
    }

    @Override
    public void setShouldTrack(boolean shouldTrack) {
        this.shouldTrack = shouldTrack;
    }

    @Override
    protected void onInit() {
        Assert.notNull((Object)this.outputChannel, (String)"outputChannel is required");
    }

    @Override
    protected void doStart() {
    }

    @Override
    protected void doStop() {
    }

    protected void sendMessage(Message<?> message) {
        if (message == null) {
            throw new MessagingException("cannot send a null message");
        }
        if (this.shouldTrack) {
            message = MessageHistory.write(message, this);
        }
        try {
            this.messagingTemplate.send(this.outputChannel, message);
        }
        catch (Exception e) {
            if (this.errorChannel != null) {
                this.messagingTemplate.send(this.errorChannel, new ErrorMessage(e));
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new MessageDeliveryException(message, "failed to send message", e);
        }
    }
}

