/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.endpoint;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.Message;
import org.springframework.integration.core.MessageHandler;
import org.springframework.integration.core.PollableChannel;
import org.springframework.integration.endpoint.AbstractPollingEndpoint;
import org.springframework.util.Assert;

public class PollingConsumer
extends AbstractPollingEndpoint {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final PollableChannel inputChannel;
    private final MessageHandler handler;
    private volatile long receiveTimeout = 1000L;

    public PollingConsumer(PollableChannel inputChannel, MessageHandler handler) {
        Assert.notNull((Object)inputChannel, (String)"inputChannel must not be null");
        Assert.notNull((Object)handler, (String)"handler must not be null");
        this.inputChannel = inputChannel;
        this.handler = handler;
    }

    public void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    protected boolean doPoll() {
        Message<?> message;
        Message<?> message2 = message = this.receiveTimeout >= 0L ? this.inputChannel.receive(this.receiveTimeout) : this.inputChannel.receive();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Poll resulted in Message: " + message));
        }
        if (message == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Received no Message during the poll, returning 'false'");
            }
            return false;
        }
        this.handler.handleMessage(message);
        return true;
    }
}

