/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.filter;

import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.integration.Message;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.MessageRejectedException;
import org.springframework.integration.core.MessageSelector;
import org.springframework.integration.filter.AbstractMessageProcessingSelector;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageFilter
extends AbstractReplyProducingMessageHandler {
    private final MessageSelector selector;
    private volatile boolean throwExceptionOnRejection;
    private volatile MessageChannel discardChannel;

    public MessageFilter(MessageSelector selector) {
        Assert.notNull((Object)selector, (String)"selector must not be null");
        this.selector = selector;
    }

    public void setThrowExceptionOnRejection(boolean throwExceptionOnRejection) {
        this.throwExceptionOnRejection = throwExceptionOnRejection;
    }

    public void setDiscardChannel(MessageChannel discardChannel) {
        this.discardChannel = discardChannel;
    }

    @Override
    public String getComponentType() {
        return "filter";
    }

    @Override
    public final void onInit() {
        super.onInit();
        if (this.selector instanceof AbstractMessageProcessingSelector) {
            ((AbstractMessageProcessingSelector)this.selector).setConversionService(this.getConversionService());
        }
        if (this.selector instanceof BeanFactoryAware) {
            ((BeanFactoryAware)this.selector).setBeanFactory(this.getBeanFactory());
        }
    }

    @Override
    protected Object handleRequestMessage(Message<?> message) {
        if (this.selector.accept(message)) {
            return message;
        }
        if (this.discardChannel != null) {
            this.getMessagingTemplate().send(this.discardChannel, message);
        }
        if (this.throwExceptionOnRejection) {
            throw new MessageRejectedException(message, "MessageFilter '" + this.getComponentName() + "' rejected Message");
        }
        return null;
    }

    @Override
    protected boolean shouldCopyRequestHeaders() {
        return false;
    }
}

