/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.gateway;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.Message;
import org.springframework.integration.MessagingException;
import org.springframework.integration.annotation.Header;
import org.springframework.integration.annotation.Headers;
import org.springframework.integration.annotation.Payload;
import org.springframework.integration.mapping.InboundMessageMapper;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GatewayMethodInboundMessageMapper
implements InboundMessageMapper<Object[]>,
BeanFactoryAware {
    private static final SpelExpressionParser PARSER = new SpelExpressionParser();
    private final Method method;
    private final Map<String, Expression> headerExpressions;
    private final List<MethodParameter> parameterList;
    private volatile Expression payloadExpression;
    private final Map<String, Expression> parameterPayloadExpressions = new HashMap<String, Expression>();
    private final StandardEvaluationContext staticEvaluationContext = new StandardEvaluationContext();
    private volatile BeanResolver beanResolver;

    public GatewayMethodInboundMessageMapper(Method method) {
        this(method, null);
    }

    public GatewayMethodInboundMessageMapper(Method method, Map<String, Expression> headerExpressions) {
        Assert.notNull((Object)method, (String)"method must not be null");
        this.method = method;
        this.headerExpressions = headerExpressions;
        this.parameterList = GatewayMethodInboundMessageMapper.getMethodParameterList(method);
        this.payloadExpression = GatewayMethodInboundMessageMapper.parsePayloadExpression(method);
    }

    public void setPayloadExpression(String expressionString) {
        this.payloadExpression = PARSER.parseExpression(expressionString);
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        if (beanFactory != null) {
            this.beanResolver = new BeanFactoryResolver(beanFactory);
            this.staticEvaluationContext.setBeanResolver(this.beanResolver);
        }
    }

    @Override
    public Message<?> toMessage(Object[] arguments) {
        Assert.notNull((Object)arguments, (String)"cannot map null arguments to Message");
        if (arguments.length != this.parameterList.size()) {
            String prefix = arguments.length < this.parameterList.size() ? "Not enough" : "Too many";
            throw new IllegalArgumentException(prefix + " parameters provided for method [" + this.method + "], expected " + this.parameterList.size() + " but received " + arguments.length + ".");
        }
        return this.mapArgumentsToMessage(arguments);
    }

    private Message<?> mapArgumentsToMessage(Object[] arguments) {
        Object messageOrPayload = null;
        boolean foundPayloadAnnotation = false;
        HashMap<String, Object> headers = new HashMap<String, Object>();
        StandardEvaluationContext methodInvocationEvaluationContext = this.createMethodInvocationEvaluationContext(arguments);
        if (this.payloadExpression != null) {
            messageOrPayload = this.payloadExpression.getValue((EvaluationContext)methodInvocationEvaluationContext);
        }
        for (int i = 0; i < this.parameterList.size(); ++i) {
            Object argumentValue = arguments[i];
            MethodParameter methodParameter = this.parameterList.get(i);
            Annotation annotation = this.findMappingAnnotation(methodParameter.getParameterAnnotations());
            if (annotation != null) {
                if (annotation.annotationType().equals(Payload.class)) {
                    String expression;
                    if (messageOrPayload != null) {
                        this.throwExceptionForMultipleMessageOrPayloadParameters(methodParameter);
                    }
                    messageOrPayload = !StringUtils.hasText((String)(expression = ((Payload)annotation).value())) ? argumentValue : this.evaluatePayloadExpression(expression, argumentValue);
                    foundPayloadAnnotation = true;
                    continue;
                }
                if (annotation.annotationType().equals(Header.class)) {
                    Header headerAnnotation = (Header)annotation;
                    String headerName = this.determineHeaderName(headerAnnotation, methodParameter);
                    if (headerAnnotation.required() && argumentValue == null) {
                        throw new IllegalArgumentException("Received null argument value for required header: '" + headerName + "'");
                    }
                    headers.put(headerName, argumentValue);
                    continue;
                }
                if (!annotation.annotationType().equals(Headers.class) || argumentValue == null) continue;
                if (!(argumentValue instanceof Map)) {
                    throw new IllegalArgumentException("@Headers annotation is only valid for Map-typed parameters");
                }
                for (Object key : ((Map)argumentValue).keySet()) {
                    Assert.isInstanceOf(String.class, key, (String)("Invalid header name [" + key + "], name type must be String."));
                    Object value = ((Map)argumentValue).get(key);
                    headers.put((String)key, value);
                }
                continue;
            }
            if (messageOrPayload == null) {
                messageOrPayload = argumentValue;
                continue;
            }
            if (Map.class.isAssignableFrom(methodParameter.getParameterType())) {
                if (messageOrPayload instanceof Map && !foundPayloadAnnotation) {
                    throw new MessagingException("Ambiguous method parameters; found more than one Map-typed parameter and neither one contains a @Payload annotation");
                }
                this.copyHeaders((Map)argumentValue, headers);
                continue;
            }
            if (this.payloadExpression != null) continue;
            this.throwExceptionForMultipleMessageOrPayloadParameters(methodParameter);
        }
        Assert.isTrue((messageOrPayload != null ? 1 : 0) != 0, (String)("unable to determine a Message or payload parameter on method [" + this.method + "]"));
        MessageBuilder<Object> builder = messageOrPayload instanceof Message ? MessageBuilder.fromMessage((Message)messageOrPayload) : MessageBuilder.withPayload(messageOrPayload);
        builder.copyHeadersIfAbsent(headers);
        if (!CollectionUtils.isEmpty(this.headerExpressions)) {
            HashMap<String, Object> evaluatedHeaders = new HashMap<String, Object>();
            for (Map.Entry<String, Expression> entry : this.headerExpressions.entrySet()) {
                Object value = entry.getValue().getValue((EvaluationContext)methodInvocationEvaluationContext);
                if (value == null) continue;
                evaluatedHeaders.put(entry.getKey(), value);
            }
            builder.copyHeaders(evaluatedHeaders);
        }
        return builder.build();
    }

    private StandardEvaluationContext createMethodInvocationEvaluationContext(Object[] arguments) {
        StandardEvaluationContext context = new StandardEvaluationContext();
        context.setVariable("args", (Object)arguments);
        context.setVariable("method", (Object)this.method.getName());
        if (this.beanResolver != null) {
            context.setBeanResolver(this.beanResolver);
        }
        return context;
    }

    private Object evaluatePayloadExpression(String expressionString, Object argumentValue) {
        Expression expression = this.parameterPayloadExpressions.get(expressionString);
        if (expression == null) {
            expression = PARSER.parseExpression(expressionString);
            this.parameterPayloadExpressions.put(expressionString, expression);
        }
        return expression.getValue((EvaluationContext)this.staticEvaluationContext, argumentValue);
    }

    private Annotation findMappingAnnotation(Annotation[] annotations) {
        if (annotations == null || annotations.length == 0) {
            return null;
        }
        Annotation match = null;
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> type = annotation.annotationType();
            if (!type.equals(Payload.class) && !type.equals(Header.class) && !type.equals(Headers.class)) continue;
            if (match != null) {
                throw new MessagingException("At most one parameter annotation can be provided for message mapping, but found two: [" + match.annotationType().getName() + "] and [" + annotation.annotationType().getName() + "]");
            }
            match = annotation;
        }
        return match;
    }

    private void copyHeaders(Map<?, ?> argumentValue, Map<String, Object> headers) {
        for (Object key : argumentValue.keySet()) {
            if (!(key instanceof String)) {
                throw new IllegalArgumentException("Invalid header name [" + key + "], name type must be String.");
            }
            Object value = argumentValue.get(key);
            headers.put((String)key, value);
        }
    }

    private void throwExceptionForMultipleMessageOrPayloadParameters(MethodParameter methodParameter) {
        throw new MessagingException("At most one parameter (or expression via method-level @Payload) may be mapped to the payload or Message. Found more than one on method [" + methodParameter.getMethod() + "]");
    }

    private String determineHeaderName(Header headerAnnotation, MethodParameter methodParameter) {
        String valueAttribute = headerAnnotation.value();
        String headerName = StringUtils.hasText((String)valueAttribute) ? valueAttribute : methodParameter.getParameterName();
        Assert.notNull((Object)headerName, (String)"Cannot determine header name. Possible reasons: -debug is disabled or header name is not explicitly provided via @Header annotation.");
        return headerName;
    }

    private static List<MethodParameter> getMethodParameterList(Method method) {
        LinkedList<MethodParameter> parameterList = new LinkedList<MethodParameter>();
        LocalVariableTableParameterNameDiscoverer parameterNameDiscoverer = new LocalVariableTableParameterNameDiscoverer();
        int parameterCount = method.getParameterTypes().length;
        for (int i = 0; i < parameterCount; ++i) {
            MethodParameter methodParameter = new MethodParameter(method, i);
            methodParameter.initParameterNameDiscovery((ParameterNameDiscoverer)parameterNameDiscoverer);
            parameterList.add(methodParameter);
        }
        return parameterList;
    }

    private static Expression parsePayloadExpression(Method method) {
        Expression expression = null;
        Payload payload = method.getAnnotation(Payload.class);
        if (payload != null) {
            String expressionString = payload.value();
            Assert.hasText((String)expressionString, (String)"@Payload at method-level on a Gateway must provide a non-empty Expression.");
            expression = PARSER.parseExpression(expressionString);
        }
        return expression;
    }
}

