/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.handler;

import java.util.Date;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.Ordered;
import org.springframework.integration.Message;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.MessageHandlingException;
import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.integration.core.MessageHandler;
import org.springframework.integration.core.MessageProducer;
import org.springframework.integration.core.MessagingTemplate;
import org.springframework.integration.message.ErrorMessage;
import org.springframework.integration.store.MessageStore;
import org.springframework.integration.store.SimpleMessageStore;
import org.springframework.integration.support.channel.BeanFactoryChannelResolver;
import org.springframework.integration.support.channel.ChannelResolutionException;
import org.springframework.integration.support.channel.ChannelResolver;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ExecutorConfigurationSupport;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelayHandler
extends IntegrationObjectSupport
implements MessageHandler,
MessageProducer,
Ordered,
DisposableBean {
    private final Log logger = LogFactory.getLog(this.getClass());
    private volatile long defaultDelay;
    private volatile String delayHeaderName;
    private boolean waitForTasksToCompleteOnShutdown = false;
    private volatile MessageChannel outputChannel;
    private volatile ChannelResolver channelResolver;
    private volatile MessageStore messageStore;
    private final MessagingTemplate messagingTemplate = new MessagingTemplate();
    private volatile int order = Integer.MAX_VALUE;

    public DelayHandler(long defaultDelay) {
        this(defaultDelay, null);
    }

    public DelayHandler(long defaultDelay, TaskScheduler taskScheduler) {
        this.defaultDelay = defaultDelay;
        this.setTaskScheduler((TaskScheduler)(taskScheduler != null ? taskScheduler : new ThreadPoolTaskScheduler()));
    }

    public void setDefaultDelay(long defaultDelay) {
        this.defaultDelay = defaultDelay;
    }

    public void setDelayHeaderName(String delayHeaderName) {
        this.delayHeaderName = delayHeaderName;
    }

    public void setMessageStore(MessageStore messageStore) {
        this.messageStore = messageStore;
    }

    @Override
    public void setOutputChannel(MessageChannel outputChannel) {
        this.outputChannel = outputChannel;
    }

    public void setSendTimeout(long sendTimeout) {
        this.messagingTemplate.setSendTimeout(sendTimeout);
    }

    public void setWaitForTasksToCompleteOnShutdown(boolean waitForJobsToCompleteOnShutdown) {
        this.waitForTasksToCompleteOnShutdown = waitForJobsToCompleteOnShutdown;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    @Override
    public String getComponentType() {
        return "delayer";
    }

    @Override
    protected void onInit() throws Exception {
        if (this.getTaskScheduler() instanceof ExecutorConfigurationSupport) {
            ((ExecutorConfigurationSupport)this.getTaskScheduler()).setWaitForTasksToCompleteOnShutdown(this.waitForTasksToCompleteOnShutdown);
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)("The 'waitForJobsToCompleteOnShutdown' property is not supported for TaskScheduler of type [" + this.getTaskScheduler().getClass() + "]"));
        }
        if (this.messageStore == null) {
            this.messageStore = new SimpleMessageStore();
        }
        if (this.getTaskScheduler() instanceof InitializingBean) {
            ((InitializingBean)this.getTaskScheduler()).afterPropertiesSet();
        }
        if (this.getBeanFactory() != null) {
            this.channelResolver = new BeanFactoryChannelResolver(this.getBeanFactory());
        }
    }

    @Override
    public final void handleMessage(Message<?> message) {
        long delay = this.determineDelayForMessage(message);
        if (delay > 0L) {
            this.releaseMessageAfterDelay(message, delay);
        } else {
            this.sendMessageToReplyChannel(message);
        }
    }

    private long determineDelayForMessage(Message<?> message) {
        long delay;
        block6: {
            delay = this.defaultDelay;
            if (this.delayHeaderName != null) {
                Object headerValue = message.getHeaders().get(this.delayHeaderName);
                if (headerValue instanceof Date) {
                    delay = ((Date)headerValue).getTime() - new Date().getTime();
                } else if (headerValue != null) {
                    try {
                        delay = Long.valueOf(headerValue.toString());
                    }
                    catch (NumberFormatException e) {
                        if (!this.logger.isDebugEnabled()) break block6;
                        this.logger.debug((Object)("Failed to parse delay from header value '" + headerValue.toString() + "', will fall back to default delay: " + this.defaultDelay));
                    }
                }
            }
        }
        return delay;
    }

    private void releaseMessageAfterDelay(final Message<?> message, long delay) {
        Assert.state((this.messageStore != null ? 1 : 0) != 0, (String)"MessageStore must not be null");
        final Message<?> storedMessage = this.messageStore.addMessage(message);
        this.getTaskScheduler().schedule(new Runnable(){

            public void run() {
                block6: {
                    try {
                        DelayHandler.this.releaseMessage(storedMessage.getHeaders().getId());
                    }
                    catch (Exception e) {
                        MessageHandlingException exception = new MessageHandlingException(message, "Failed to deliver Message after delay.", e);
                        MessageChannel errorChannel = DelayHandler.this.resolveErrorChannelIfPossible(message);
                        if (errorChannel != null) {
                            ErrorMessage errorMessage = new ErrorMessage(exception);
                            try {
                                DelayHandler.this.messagingTemplate.send(errorChannel, errorMessage);
                            }
                            catch (Exception e2) {
                                if (DelayHandler.this.logger.isWarnEnabled()) {
                                    DelayHandler.this.logger.warn((Object)"Failed to send MessagingException to error channel.", (Throwable)exception);
                                }
                                break block6;
                            }
                        }
                        if (!DelayHandler.this.logger.isWarnEnabled()) break block6;
                        DelayHandler.this.logger.warn((Object)"No error channel available. MessagingException will be ignored.", (Throwable)exception);
                    }
                }
            }
        }, new Date(System.currentTimeMillis() + delay));
    }

    private void releaseMessage(UUID id) {
        Assert.state((this.messageStore != null ? 1 : 0) != 0, (String)"MessageStore must not be null");
        Message<?> message = this.messageStore.removeMessage(id);
        Assert.notNull(message, (String)("Message with id: " + id + " no longer exists in MessageStore."));
        this.sendMessageToReplyChannel(message);
    }

    private void sendMessageToReplyChannel(Message<?> message) {
        MessageChannel replyChannel = this.resolveReplyChannel(message);
        this.messagingTemplate.send(replyChannel, message);
    }

    private MessageChannel resolveReplyChannel(Message<?> message) {
        MessageChannel replyChannel = this.outputChannel;
        if (replyChannel == null) {
            replyChannel = this.resolveChannelFromHeader(message, "replyChannel");
        }
        if (replyChannel == null) {
            throw new ChannelResolutionException("unable to resolve reply channel for message: " + message);
        }
        return replyChannel;
    }

    private MessageChannel resolveErrorChannelIfPossible(Message<?> message) {
        MessageChannel errorChannel;
        block3: {
            errorChannel = null;
            try {
                errorChannel = this.resolveChannelFromHeader(message, "errorChannel");
            }
            catch (Exception e) {
                if (!this.logger.isWarnEnabled()) break block3;
                this.logger.warn((Object)"Failed to resolve error channel from header.", (Throwable)e);
            }
        }
        if (errorChannel == null && this.channelResolver != null) {
            errorChannel = this.channelResolver.resolveChannelName("errorChannel");
        }
        return errorChannel;
    }

    private MessageChannel resolveChannelFromHeader(Message<?> message, String headerName) {
        MessageChannel channel = null;
        Object channelHeader = message.getHeaders().get(headerName);
        if (channelHeader != null) {
            if (channelHeader instanceof MessageChannel) {
                channel = (MessageChannel)channelHeader;
            } else if (channelHeader instanceof String) {
                Assert.state((this.channelResolver != null ? 1 : 0) != 0, (String)("ChannelResolver is required for resolving '" + headerName + "' by name."));
                channel = this.channelResolver.resolveChannelName((String)channelHeader);
            } else {
                throw new ChannelResolutionException("expected a MessageChannel or String for '" + headerName + "', but type is [" + channelHeader.getClass() + "]");
            }
        }
        return channel;
    }

    public void destroy() throws Exception {
        if (this.getTaskScheduler() instanceof DisposableBean) {
            ((DisposableBean)this.getTaskScheduler()).destroy();
        }
    }
}

