/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.handler;

import org.springframework.expression.Expression;
import org.springframework.integration.Message;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.integration.handler.ExpressionEvaluatingMessageProcessor;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionEvaluatingMessageHandler
extends AbstractMessageHandler {
    private volatile ExpressionEvaluatingMessageProcessor<Void> processor;
    private volatile String componentType;

    public ExpressionEvaluatingMessageHandler(Expression expression) {
        Assert.notNull((Object)expression, (String)"Expression must not be null");
        this.processor = new ExpressionEvaluatingMessageProcessor<Void>(expression, Void.class);
    }

    public void setComponentType(String componentType) {
        this.componentType = componentType;
    }

    @Override
    public String getComponentType() {
        return this.componentType;
    }

    @Override
    protected void onInit() throws Exception {
        this.processor.setBeanFactory(this.getBeanFactory());
    }

    @Override
    protected void handleMessageInternal(Message<?> message) throws Exception {
        this.processor.processMessage(message);
    }
}

