/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.handler;

import java.lang.reflect.Method;
import org.springframework.integration.Message;
import org.springframework.integration.MessagingException;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.integration.handler.MethodInvokingMessageProcessor;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInvokingMessageHandler
extends AbstractMessageHandler {
    private volatile MethodInvokingMessageProcessor<Object> processor;
    private volatile String componentType;

    public MethodInvokingMessageHandler(Object object, Method method) {
        Assert.isTrue((boolean)method.getReturnType().equals(Void.TYPE), (String)"MethodInvokingMessageHandler requires a void-returning method");
        this.processor = new MethodInvokingMessageProcessor(object, method);
    }

    public MethodInvokingMessageHandler(Object object, String methodName) {
        this.processor = new MethodInvokingMessageProcessor(object, methodName);
    }

    public void setComponentType(String componentType) {
        this.componentType = componentType;
    }

    @Override
    public String getComponentType() {
        return this.componentType;
    }

    @Override
    protected void handleMessageInternal(Message<?> message) throws Exception {
        Object result = this.processor.processMessage(message);
        if (result != null) {
            throw new MessagingException(message, "the MethodInvokingMessageHandler method must have a void return, but '" + this + "' received a value: [" + result + "]");
        }
    }
}

