/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.history;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.SmartLifecycle;
import org.springframework.integration.history.TrackableComponent;
import org.springframework.util.Assert;
import org.springframework.util.PatternMatchUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageHistoryConfigurer
implements SmartLifecycle,
BeanFactoryAware {
    private final Log logger = LogFactory.getLog(this.getClass());
    private volatile String[] componentNamePatterns = new String[]{"*"};
    private final Set<String> currentlyTrackedComponentNames = new HashSet<String>();
    private volatile BeanFactory beanFactory;
    private volatile boolean running;
    private volatile boolean autoStartup = true;
    private int phase = Integer.MIN_VALUE;
    private final Object lifecycleMonitor = new Object();

    public void setComponentNamePatterns(String[] componentNamePatterns) {
        Assert.notEmpty((Object[])componentNamePatterns, (String)"componentNamePatterns must not be empty");
        this.componentNamePatterns = componentNamePatterns;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    private static Collection<TrackableComponent> getTrackableComponents(ListableBeanFactory beanFactory) {
        return BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)beanFactory, TrackableComponent.class).values();
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public int getPhase() {
        return this.phase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (!this.running && this.beanFactory instanceof ListableBeanFactory) {
                for (TrackableComponent component : MessageHistoryConfigurer.getTrackableComponents((ListableBeanFactory)this.beanFactory)) {
                    String componentName = component.getComponentName();
                    boolean shouldTrack = PatternMatchUtils.simpleMatch((String[])this.componentNamePatterns, (String)componentName);
                    component.setShouldTrack(shouldTrack);
                    if (!shouldTrack) continue;
                    this.currentlyTrackedComponentNames.add(componentName);
                    if (!this.logger.isInfoEnabled()) continue;
                    this.logger.info((Object)("Enabling MessageHistory tracking for component '" + componentName + "'"));
                }
                this.running = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.running && this.beanFactory instanceof ListableBeanFactory) {
                for (TrackableComponent component : MessageHistoryConfigurer.getTrackableComponents((ListableBeanFactory)this.beanFactory)) {
                    String componentName = component.getComponentName();
                    if (!this.currentlyTrackedComponentNames.contains(componentName)) continue;
                    component.setShouldTrack(false);
                    if (!this.logger.isInfoEnabled()) continue;
                    this.logger.info((Object)("Disabling MessageHistory tracking for component '" + componentName + "'"));
                }
                this.currentlyTrackedComponentNames.clear();
                this.running = false;
            }
        }
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }
}

