/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.json;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.type.TypeFactory;
import org.codehaus.jackson.type.JavaType;
import org.codehaus.jackson.type.TypeReference;
import org.springframework.integration.Message;
import org.springframework.integration.mapping.InboundMessageMapper;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonInboundMessageMapper
implements InboundMessageMapper<String> {
    private static final String MESSAGE_FORMAT_ERROR = "JSON message is invalid.  Expected a message in the format of either {\"headers\":{...},\"payload\":{...}} or {\"payload\":{...}.\"headers\":{...}} but was ";
    private static final Map<String, Class<?>> DEFAULT_HEADER_TYPES = new HashMap();
    private final JavaType payloadType;
    private final Map<String, Class<?>> headerTypes = DEFAULT_HEADER_TYPES;
    private volatile ObjectMapper objectMapper = new ObjectMapper();
    private volatile boolean mapToPayload = false;

    public JsonInboundMessageMapper(Class<?> payloadType) {
        Assert.notNull(payloadType, (String)"payloadType must not be null");
        this.payloadType = TypeFactory.defaultInstance().constructType(payloadType);
    }

    public JsonInboundMessageMapper(TypeReference<?> typeReference) {
        Assert.notNull(typeReference, (String)"typeReference must not be null");
        this.payloadType = TypeFactory.defaultInstance().constructType(typeReference);
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        Assert.notNull((Object)objectMapper, (String)"objectMapper must not be null");
        this.objectMapper = objectMapper;
    }

    public void setHeaderTypes(Map<String, Class<?>> headerTypes) {
        this.headerTypes.putAll(headerTypes);
    }

    public void setMapToPayload(boolean mapToPayload) {
        this.mapToPayload = mapToPayload;
    }

    @Override
    public Message<?> toMessage(String jsonMessage) throws Exception {
        JsonParser parser = new JsonFactory().createJsonParser(jsonMessage);
        if (this.mapToPayload) {
            try {
                return MessageBuilder.withPayload(this.readPayload(parser, jsonMessage)).build();
            }
            catch (JsonMappingException ex) {
                throw new IllegalArgumentException("Mapping of JSON message " + jsonMessage + " directly to payload of type " + this.payloadType.getRawClass().getName() + " failed.", ex);
            }
        }
        String error = MESSAGE_FORMAT_ERROR + jsonMessage;
        Assert.isTrue((parser.nextToken() == JsonToken.START_OBJECT ? 1 : 0) != 0, (String)error);
        Map<String, Object> headers = null;
        Object payload = null;
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            Assert.isTrue((parser.getCurrentToken() == JsonToken.FIELD_NAME ? 1 : 0) != 0, (String)error);
            boolean isHeadersToken = "headers".equals(parser.getCurrentName());
            boolean isPayloadToken = "payload".equals(parser.getCurrentName());
            Assert.isTrue((isHeadersToken || isPayloadToken ? 1 : 0) != 0, (String)error);
            if (isHeadersToken) {
                Assert.isTrue((parser.nextToken() == JsonToken.START_OBJECT ? 1 : 0) != 0, (String)error);
                headers = this.readHeaders(parser, jsonMessage);
                continue;
            }
            if (!isPayloadToken) continue;
            parser.nextToken();
            try {
                payload = this.readPayload(parser, jsonMessage);
            }
            catch (JsonMappingException ex) {
                throw new IllegalArgumentException("Mapping payload of JSON message " + jsonMessage + " to payload type " + this.payloadType.getRawClass().getName() + " failed.", ex);
            }
        }
        Assert.notNull(headers, (String)error);
        return MessageBuilder.withPayload(payload).copyHeaders(headers).build();
    }

    protected Map<String, Object> readHeaders(JsonParser parser, String jsonMessage) throws Exception {
        LinkedHashMap<String, Object> headers = new LinkedHashMap<String, Object>();
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            String headerName = parser.getCurrentName();
            parser.nextToken();
            Class<Object> headerType = this.headerTypes.containsKey(headerName) ? this.headerTypes.get(headerName) : Object.class;
            try {
                headers.put(headerName, this.objectMapper.readValue(parser, headerType));
            }
            catch (JsonMappingException ex) {
                throw new IllegalArgumentException("Mapping header \"" + headerName + "\" of JSON message " + jsonMessage + " to header type " + this.payloadType.getRawClass().getName() + " failed.", ex);
            }
        }
        return headers;
    }

    protected Object readPayload(JsonParser parser, String jsonMessage) throws Exception {
        return this.objectMapper.readValue(parser, this.payloadType);
    }

    static {
        DEFAULT_HEADER_TYPES.put("priority", Integer.class);
        DEFAULT_HEADER_TYPES.put("expirationDate", Long.class);
        DEFAULT_HEADER_TYPES.put("sequenceSize", Integer.class);
        DEFAULT_HEADER_TYPES.put("sequenceNumber", Integer.class);
    }
}

