/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.json;

import java.io.StringWriter;
import java.io.Writer;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.integration.Message;
import org.springframework.integration.mapping.OutboundMessageMapper;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonOutboundMessageMapper
implements OutboundMessageMapper<String> {
    private volatile boolean shouldExtractPayload = false;
    private volatile ObjectMapper objectMapper = new ObjectMapper();

    public void setObjectMapper(ObjectMapper objectMapper) {
        Assert.notNull((Object)objectMapper, (String)"objectMapper must not be null");
        this.objectMapper = objectMapper;
    }

    public void setShouldExtractPayload(boolean shouldExtractPayload) {
        this.shouldExtractPayload = shouldExtractPayload;
    }

    @Override
    public String fromMessage(Message<?> message) throws Exception {
        StringWriter writer = new StringWriter();
        if (this.shouldExtractPayload) {
            this.objectMapper.writeValue((Writer)writer, message.getPayload());
        } else {
            this.objectMapper.writeValue((Writer)writer, message);
        }
        return writer.toString();
    }
}

