/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.json;

import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.integration.transformer.AbstractPayloadTransformer;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonToObjectTransformer<T>
extends AbstractPayloadTransformer<String, T> {
    private final Class<T> targetClass;
    private final ObjectMapper objectMapper;

    public JsonToObjectTransformer(Class<T> targetClass) {
        this(targetClass, null);
    }

    public JsonToObjectTransformer(Class<T> targetClass, ObjectMapper objectMapper) {
        Assert.notNull(targetClass, (String)"targetClass must not be null");
        this.targetClass = targetClass;
        this.objectMapper = objectMapper != null ? objectMapper : new ObjectMapper();
    }

    @Override
    protected T transformPayload(String payload) throws Exception {
        return (T)this.objectMapper.readValue(payload, this.targetClass);
    }
}

