/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.json;

import java.io.StringWriter;
import java.io.Writer;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.integration.transformer.AbstractPayloadTransformer;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectToJsonTransformer
extends AbstractPayloadTransformer<Object, String> {
    private final ObjectMapper objectMapper;

    public ObjectToJsonTransformer(ObjectMapper objectMapper) {
        Assert.notNull((Object)objectMapper, (String)"objectMapper must not be null");
        this.objectMapper = objectMapper;
    }

    public ObjectToJsonTransformer() {
        this.objectMapper = new ObjectMapper();
    }

    @Override
    protected String transformPayload(Object payload) throws Exception {
        StringWriter writer = new StringWriter();
        this.objectMapper.writeValue((Writer)writer, payload);
        return writer.toString();
    }
}

