/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.store;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.store.MessageGroup;
import org.springframework.integration.store.MessageGroupCallback;
import org.springframework.integration.store.MessageGroupStore;
import org.springframework.jmx.export.annotation.ManagedAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessageGroupStore
implements MessageGroupStore,
Iterable<MessageGroup> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Collection<MessageGroupCallback> expiryCallbacks = new LinkedHashSet<MessageGroupCallback>();
    private volatile boolean timeoutOnIdle;

    public void setExpiryCallbacks(Collection<MessageGroupCallback> expiryCallbacks) {
        for (MessageGroupCallback callback : expiryCallbacks) {
            this.registerMessageGroupExpiryCallback(callback);
        }
    }

    public boolean isTimeoutOnIdle() {
        return this.timeoutOnIdle;
    }

    public void setTimeoutOnIdle(boolean timeoutOnIdle) {
        this.timeoutOnIdle = timeoutOnIdle;
    }

    @Override
    public void registerMessageGroupExpiryCallback(MessageGroupCallback callback) {
        this.expiryCallbacks.add(callback);
    }

    @Override
    public int expireMessageGroups(long timeout) {
        int count = 0;
        long threshold = System.currentTimeMillis() - timeout;
        for (MessageGroup group : this) {
            long timestamp = group.getTimestamp();
            if (this.isTimeoutOnIdle() && group.getLastModified() > 0L) {
                timestamp = group.getLastModified();
            }
            if (timestamp > threshold) continue;
            ++count;
            this.expire(group);
        }
        return count;
    }

    @Override
    @ManagedAttribute
    public int getMessageCountForAllMessageGroups() {
        int count = 0;
        for (MessageGroup group : this) {
            count += group.size();
        }
        return count;
    }

    @Override
    @ManagedAttribute
    public int getMessageGroupCount() {
        int count = 0;
        for (MessageGroup group : this) {
            ++count;
        }
        return count;
    }

    private void expire(MessageGroup group) {
        RuntimeException exception = null;
        for (MessageGroupCallback callback : this.expiryCallbacks) {
            try {
                callback.execute(this, group);
            }
            catch (RuntimeException e) {
                if (exception == null) {
                    exception = e;
                }
                this.logger.error((Object)"Exception in expiry callback", (Throwable)e);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }
}

