/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.store;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.integration.Message;
import org.springframework.integration.MessagingException;
import org.springframework.integration.store.AbstractMessageGroupStore;
import org.springframework.integration.store.MessageGroup;
import org.springframework.integration.store.MessageGroupStore;
import org.springframework.integration.store.MessageStore;
import org.springframework.integration.store.SimpleMessageGroup;
import org.springframework.integration.util.UpperBound;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedResource
public class SimpleMessageStore
extends AbstractMessageGroupStore
implements MessageStore,
MessageGroupStore {
    private final ConcurrentMap<Object, Object> locks = new ConcurrentHashMap<Object, Object>();
    private final ConcurrentMap<UUID, Message<?>> idToMessage = new ConcurrentHashMap();
    private final ConcurrentMap<Object, SimpleMessageGroup> groupIdToMessageGroup = new ConcurrentHashMap<Object, SimpleMessageGroup>();
    private final UpperBound individualUpperBound;
    private final UpperBound groupUpperBound;

    public SimpleMessageStore(int individualCapacity, int groupCapacity) {
        this.individualUpperBound = new UpperBound(individualCapacity);
        this.groupUpperBound = new UpperBound(groupCapacity);
    }

    public SimpleMessageStore(int capacity) {
        this(capacity, capacity);
    }

    public SimpleMessageStore() {
        this(0);
    }

    @Override
    @ManagedAttribute
    public long getMessageCount() {
        return this.idToMessage.size();
    }

    @Override
    public <T> Message<T> addMessage(Message<T> message) {
        if (!this.individualUpperBound.tryAcquire(0L)) {
            throw new MessagingException(this.getClass().getSimpleName() + " was out of capacity at, try constructing it with a larger capacity.");
        }
        this.idToMessage.put(message.getHeaders().getId(), message);
        return message;
    }

    @Override
    public Message<?> getMessage(UUID key) {
        return key != null ? (Message)this.idToMessage.get(key) : null;
    }

    @Override
    public Message<?> removeMessage(UUID key) {
        if (key != null) {
            this.individualUpperBound.release();
            return (Message)this.idToMessage.remove(key);
        }
        return null;
    }

    @Override
    public MessageGroup getMessageGroup(Object groupId) {
        Assert.notNull((Object)groupId, (String)"'groupId' must not be null");
        SimpleMessageGroup group = (SimpleMessageGroup)this.groupIdToMessageGroup.get(groupId);
        if (group == null) {
            return new SimpleMessageGroup(groupId);
        }
        return new SimpleMessageGroup(group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageGroup addMessageToGroup(Object groupId, Message<?> message) {
        Object lock;
        if (!this.groupUpperBound.tryAcquire(0L)) {
            throw new MessagingException(this.getClass().getSimpleName() + " was out of capacity at, try constructing it with a larger capacity.");
        }
        Object object = lock = this.obtainLock(groupId);
        synchronized (object) {
            SimpleMessageGroup group = (SimpleMessageGroup)this.groupIdToMessageGroup.get(groupId);
            if (group == null) {
                group = new SimpleMessageGroup(groupId);
                this.groupIdToMessageGroup.putIfAbsent(groupId, group);
            }
            group.add(message);
            return group;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMessageGroup(Object groupId) {
        Object lock;
        Object object = lock = this.obtainLock(groupId);
        synchronized (object) {
            if (!this.groupIdToMessageGroup.containsKey(groupId)) {
                return;
            }
            this.groupUpperBound.release(((SimpleMessageGroup)this.groupIdToMessageGroup.get(groupId)).size());
            this.groupIdToMessageGroup.remove(groupId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageGroup removeMessageFromGroup(Object groupId, Message<?> messageToRemove) {
        Object lock;
        Object object = lock = this.obtainLock(groupId);
        synchronized (object) {
            SimpleMessageGroup group = (SimpleMessageGroup)this.groupIdToMessageGroup.get(groupId);
            Assert.notNull((Object)group, (String)("MessageGroup for groupId '" + groupId + "' " + "can not be located while attempting to remove Message from the MessageGroup"));
            group.remove(messageToRemove);
            return group;
        }
    }

    @Override
    public Iterator<MessageGroup> iterator() {
        return new HashSet(this.groupIdToMessageGroup.values()).iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLastReleasedSequenceNumberForGroup(Object groupId, int sequenceNumber) {
        Object lock;
        Object object = lock = this.obtainLock(groupId);
        synchronized (object) {
            SimpleMessageGroup group = (SimpleMessageGroup)this.groupIdToMessageGroup.get(groupId);
            Assert.notNull((Object)group, (String)("MessageGroup for groupId '" + groupId + "' " + "can not be located while attempting to set 'lastReleasedSequenceNumber'"));
            group.setLastReleasedMessageSequenceNumber(sequenceNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completeGroup(Object groupId) {
        Object lock;
        Object object = lock = this.obtainLock(groupId);
        synchronized (object) {
            SimpleMessageGroup group = (SimpleMessageGroup)this.groupIdToMessageGroup.get(groupId);
            Assert.notNull((Object)group, (String)("MessageGroup for groupId '" + groupId + "' " + "can not be located while attempting to complete the MessageGroup"));
            group.complete();
        }
    }

    @Override
    public Message<?> pollMessageFromGroup(Object groupId) {
        Collection<Message<?>> messageList = this.getMessageGroup(groupId).getMessages();
        Message<?> message = null;
        if (!CollectionUtils.isEmpty(messageList) && (message = messageList.iterator().next()) != null) {
            this.removeMessageFromGroup(groupId, message);
        }
        return message;
    }

    private Object obtainLock(Object groupId) {
        Object lock = this.locks.get(groupId);
        if (lock == null) {
            Object newLock = new Object();
            Object previousLock = this.locks.putIfAbsent(groupId, newLock);
            lock = previousLock == null ? newLock : previousLock;
        }
        return lock;
    }

    @Override
    public int messageGroupSize(Object groupId) {
        return this.getMessageGroup(groupId).size();
    }
}

