/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.springframework.integration.Message;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.message.ErrorMessage;
import org.springframework.integration.message.GenericMessage;
import org.springframework.util.Assert;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MessageBuilder<T> {
    private final T payload;
    private final Map<String, Object> headers = new HashMap<String, Object>();
    private final Message<T> originalMessage;
    private volatile boolean modified;

    private MessageBuilder(T payload, Message<T> originalMessage) {
        Assert.notNull(payload, (String)"payload must not be null");
        this.payload = payload;
        this.originalMessage = originalMessage;
        if (originalMessage != null) {
            this.copyHeaders(originalMessage.getHeaders());
            this.modified = !this.payload.equals(originalMessage.getPayload());
        }
    }

    public static <T> MessageBuilder<T> fromMessage(Message<T> message) {
        Assert.notNull(message, (String)"message must not be null");
        MessageBuilder<T> builder = new MessageBuilder<T>(message.getPayload(), message);
        return builder;
    }

    public static <T> MessageBuilder<T> withPayload(T payload) {
        MessageBuilder<T> builder = new MessageBuilder<T>(payload, null);
        return builder;
    }

    public MessageBuilder<T> setHeader(String headerName, Object headerValue) {
        Assert.isTrue((!this.isReadOnly(headerName) ? 1 : 0) != 0, (String)("The '" + headerName + "' header is read-only."));
        if (StringUtils.hasLength((String)headerName) && !headerName.equals("id") && !headerName.equals("timestamp")) {
            this.verifyType(headerName, headerValue);
            if (headerValue == null) {
                Object removedValue = this.headers.remove(headerName);
                if (removedValue != null) {
                    this.modified = true;
                }
            } else {
                Object replacedValue = this.headers.put(headerName, headerValue);
                if (!headerValue.equals(replacedValue)) {
                    this.modified = true;
                }
            }
        }
        return this;
    }

    public MessageBuilder<T> setHeaderIfAbsent(String headerName, Object headerValue) {
        if (this.headers.get(headerName) == null) {
            this.setHeader(headerName, headerValue);
        }
        return this;
    }

    public MessageBuilder<T> removeHeaders(String ... headerPatterns) {
        ArrayList<String> headersToRemove = new ArrayList<String>();
        for (String pattern : headerPatterns) {
            if (!StringUtils.hasLength((String)pattern)) continue;
            if (pattern.contains("*")) {
                for (String headerName : this.headers.keySet()) {
                    if (!PatternMatchUtils.simpleMatch((String)pattern, (String)headerName)) continue;
                    headersToRemove.add(headerName);
                }
                continue;
            }
            headersToRemove.add(pattern);
        }
        for (String headerToRemove : headersToRemove) {
            this.removeHeader(headerToRemove);
        }
        return this;
    }

    public MessageBuilder<T> removeHeader(String headerName) {
        Object removedValue;
        if (StringUtils.hasLength((String)headerName) && !headerName.equals("id") && !headerName.equals("timestamp") && (removedValue = this.headers.remove(headerName)) != null) {
            this.modified = true;
        }
        return this;
    }

    public MessageBuilder<T> copyHeaders(Map<String, ?> headersToCopy) {
        Set<String> keys = headersToCopy.keySet();
        for (String key : keys) {
            if (this.isReadOnly(key)) continue;
            this.setHeader(key, headersToCopy.get(key));
        }
        return this;
    }

    public MessageBuilder<T> copyHeadersIfAbsent(Map<String, ?> headersToCopy) {
        Set<String> keys = headersToCopy.keySet();
        for (String key : keys) {
            if (this.isReadOnly(key)) continue;
            this.setHeaderIfAbsent(key, headersToCopy.get(key));
        }
        return this;
    }

    public MessageBuilder<T> setExpirationDate(Long expirationDate) {
        return this.setHeader("expirationDate", expirationDate);
    }

    public MessageBuilder<T> setExpirationDate(Date expirationDate) {
        if (expirationDate != null) {
            return this.setHeader("expirationDate", expirationDate.getTime());
        }
        return this.setHeader("expirationDate", null);
    }

    public MessageBuilder<T> setCorrelationId(Object correlationId) {
        return this.setHeader("correlationId", correlationId);
    }

    public MessageBuilder<T> pushSequenceDetails(Object correlationId, int sequenceNumber, int sequenceSize) {
        Object incomingCorrelationId = this.headers.get("correlationId");
        List<List<Object>> incomingSequenceDetails = (ArrayList<List<Object>>)this.headers.get("sequenceDetails");
        if (incomingCorrelationId != null) {
            incomingSequenceDetails = incomingSequenceDetails == null ? new ArrayList<List<Object>>() : new ArrayList(incomingSequenceDetails);
            incomingSequenceDetails.add(Arrays.asList(incomingCorrelationId, this.headers.get("sequenceNumber"), this.headers.get("sequenceSize")));
            incomingSequenceDetails = Collections.unmodifiableList(incomingSequenceDetails);
        }
        if (incomingSequenceDetails != null) {
            this.setHeader("sequenceDetails", incomingSequenceDetails);
        }
        return this.setCorrelationId(correlationId).setSequenceNumber(sequenceNumber).setSequenceSize(sequenceSize);
    }

    public MessageBuilder<T> popSequenceDetails() {
        String key = "sequenceDetails";
        if (!this.headers.containsKey(key)) {
            return this;
        }
        ArrayList incomingSequenceDetails = new ArrayList((List)this.headers.get(key));
        List sequenceDetails = (List)incomingSequenceDetails.remove(incomingSequenceDetails.size() - 1);
        Assert.state((sequenceDetails.size() == 3 ? 1 : 0) != 0, (String)("Wrong sequence details (not created by MessageBuilder?): " + sequenceDetails));
        this.setCorrelationId(sequenceDetails.get(0));
        Integer sequenceNumber = (Integer)sequenceDetails.get(1);
        Integer sequenceSize = (Integer)sequenceDetails.get(2);
        if (sequenceNumber != null) {
            this.setSequenceNumber(sequenceNumber);
        }
        if (sequenceSize != null) {
            this.setSequenceSize(sequenceSize);
        }
        if (!incomingSequenceDetails.isEmpty()) {
            this.headers.put("sequenceDetails", incomingSequenceDetails);
        } else {
            this.headers.remove("sequenceDetails");
        }
        return this;
    }

    public MessageBuilder<T> setReplyChannel(MessageChannel replyChannel) {
        return this.setHeader("replyChannel", replyChannel);
    }

    public MessageBuilder<T> setReplyChannelName(String replyChannelName) {
        return this.setHeader("replyChannel", replyChannelName);
    }

    public MessageBuilder<T> setErrorChannel(MessageChannel errorChannel) {
        return this.setHeader("errorChannel", errorChannel);
    }

    public MessageBuilder<T> setErrorChannelName(String errorChannelName) {
        return this.setHeader("errorChannel", errorChannelName);
    }

    public MessageBuilder<T> setSequenceNumber(Integer sequenceNumber) {
        return this.setHeader("sequenceNumber", sequenceNumber);
    }

    public MessageBuilder<T> setSequenceSize(Integer sequenceSize) {
        return this.setHeader("sequenceSize", sequenceSize);
    }

    public MessageBuilder<T> setPriority(Integer priority) {
        return this.setHeader("priority", priority);
    }

    public Message<T> build() {
        if (!this.modified && this.originalMessage != null) {
            return this.originalMessage;
        }
        if (this.payload instanceof Throwable) {
            return new ErrorMessage((Throwable)this.payload, this.headers);
        }
        return new GenericMessage<T>(this.payload, this.headers);
    }

    private boolean isReadOnly(String headerName) {
        return "id".equals(headerName) || "timestamp".equals(headerName);
    }

    private void verifyType(String headerName, Object headerValue) {
        if (headerName != null && headerValue != null) {
            if ("id".equals(headerName)) {
                Assert.isTrue((boolean)(headerValue instanceof UUID), (String)("The '" + headerName + "' header value must be a UUID."));
            } else if ("timestamp".equals(headerName)) {
                Assert.isTrue((boolean)(headerValue instanceof Long), (String)("The '" + headerName + "' header value must be a Long."));
            } else if ("expirationDate".equals(headerName)) {
                Assert.isTrue((headerValue instanceof Date || headerValue instanceof Long ? 1 : 0) != 0, (String)("The '" + headerName + "' header value must be a Date or Long."));
            } else if ("errorChannel".equals(headerName) || "replyChannel".endsWith(headerName)) {
                Assert.isTrue((headerValue instanceof MessageChannel || headerValue instanceof String ? 1 : 0) != 0, (String)("The '" + headerName + "' header value must be a MessageChannel or String."));
            } else if ("sequenceNumber".equals(headerName) || "sequenceSize".equals(headerName)) {
                Assert.isTrue((boolean)Integer.class.isAssignableFrom(headerValue.getClass()), (String)("The '" + headerName + "' header value must be an Integer."));
            } else if ("priority".equals(headerName)) {
                Assert.isTrue((boolean)Integer.class.isAssignableFrom(headerValue.getClass()), (String)("The '" + headerName + "' header value must be an Integer."));
            }
        }
    }
}

