/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.support.channel;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.support.channel.ChannelResolutionException;
import org.springframework.integration.support.channel.ChannelResolver;
import org.springframework.util.Assert;

public class BeanFactoryChannelResolver
implements ChannelResolver,
BeanFactoryAware {
    private volatile BeanFactory beanFactory;

    public BeanFactoryChannelResolver() {
    }

    public BeanFactoryChannelResolver(BeanFactory beanFactory) {
        Assert.notNull((Object)beanFactory, (String)"BeanFactory must not be null");
        this.beanFactory = beanFactory;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public MessageChannel resolveChannelName(String name) {
        Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory is required");
        try {
            return (MessageChannel)this.beanFactory.getBean(name, MessageChannel.class);
        }
        catch (BeansException e) {
            throw new ChannelResolutionException("failed to look up MessageChannel bean with name '" + name + "'", (Throwable)e);
        }
    }
}

