/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.transformer;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.integration.Message;
import org.springframework.integration.context.IntegrationContextUtils;
import org.springframework.integration.handler.AbstractMessageProcessor;
import org.springframework.integration.handler.MessageProcessor;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.integration.transformer.Transformer;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessageProcessingTransformer
implements Transformer,
BeanFactoryAware {
    private final MessageProcessor<?> messageProcessor;

    protected AbstractMessageProcessingTransformer(MessageProcessor<?> messageProcessor) {
        Assert.notNull(messageProcessor, (String)"messageProcessor must not be null");
        this.messageProcessor = messageProcessor;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        ConversionService conversionService;
        if (this.messageProcessor instanceof BeanFactoryAware) {
            ((BeanFactoryAware)this.messageProcessor).setBeanFactory(beanFactory);
        }
        if ((conversionService = IntegrationContextUtils.getConversionService(beanFactory)) != null && this.messageProcessor instanceof AbstractMessageProcessor) {
            ((AbstractMessageProcessor)this.messageProcessor).setConversionService(conversionService);
        }
    }

    @Override
    public final Message<?> transform(Message<?> message) {
        Object result = this.messageProcessor.processMessage(message);
        if (result == null) {
            return null;
        }
        if (result instanceof Message) {
            return (Message)result;
        }
        return MessageBuilder.withPayload(result).copyHeaders(message.getHeaders()).build();
    }
}

