/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.transformer;

import java.util.UUID;
import org.springframework.integration.Message;
import org.springframework.integration.store.MessageStore;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.integration.transformer.AbstractTransformer;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClaimCheckOutTransformer
extends AbstractTransformer {
    private final MessageStore messageStore;
    private volatile boolean removeMessage = false;

    public ClaimCheckOutTransformer(MessageStore messageStore) {
        Assert.notNull((Object)messageStore, (String)"MessageStore must not be null");
        this.messageStore = messageStore;
    }

    public void setRemoveMessage(boolean removeMessage) {
        this.removeMessage = removeMessage;
    }

    @Override
    protected Object doTransform(Message<?> message) throws Exception {
        Assert.notNull(message, (String)"message must not be null");
        Assert.isTrue((boolean)(message.getPayload() instanceof UUID), (String)"payload must be a UUID");
        UUID id = (UUID)message.getPayload();
        Message<?> retrievedMessage = this.messageStore.getMessage(id);
        Assert.notNull(retrievedMessage, (String)("unable to locate Message for ID: " + id + " within MessageStore [" + this.messageStore + "]"));
        if (this.removeMessage) {
            this.messageStore.removeMessage(id);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Removed Message with claim-check '" + id + "' from the MessageStore."));
            }
        }
        MessageBuilder<Object> responseBuilder = MessageBuilder.fromMessage(retrievedMessage);
        responseBuilder.copyHeaders(message.getHeaders());
        return responseBuilder.build();
    }
}

