/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.transformer;

import org.springframework.integration.Message;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.integration.transformer.Transformer;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeaderFilter
implements Transformer {
    private final String[] headersToRemove;
    private volatile boolean patternMatch = true;

    public HeaderFilter(String ... headersToRemove) {
        Assert.notEmpty((Object[])headersToRemove, (String)"At least one header name to remove is required.");
        this.headersToRemove = headersToRemove;
    }

    public void setPatternMatch(boolean patternMatch) {
        this.patternMatch = patternMatch;
    }

    @Override
    public Message<?> transform(Message<?> message) {
        MessageBuilder<?> builder = MessageBuilder.fromMessage(message);
        if (this.patternMatch) {
            builder.removeHeaders(this.headersToRemove);
        } else {
            for (String headerToRemove : this.headersToRemove) {
                builder.removeHeader(headerToRemove);
            }
        }
        return builder.build();
    }
}

