/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.transformer;

import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.integration.Message;
import org.springframework.integration.context.NamedComponent;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.transformer.MessageTransformationException;
import org.springframework.integration.transformer.Transformer;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageTransformingHandler
extends AbstractReplyProducingMessageHandler {
    private final Transformer transformer;

    public MessageTransformingHandler(Transformer transformer) {
        Assert.notNull((Object)transformer, (String)"transformer must not be null");
        this.transformer = transformer;
        this.setRequiresReply(true);
    }

    @Override
    public String getComponentType() {
        return this.transformer instanceof NamedComponent ? ((NamedComponent)((Object)this.transformer)).getComponentType() : "transformer";
    }

    @Override
    protected void onInit() {
        super.onInit();
        if (this.getBeanFactory() != null && this.transformer instanceof BeanFactoryAware) {
            ((BeanFactoryAware)this.transformer).setBeanFactory(this.getBeanFactory());
        }
    }

    @Override
    protected Object handleRequestMessage(Message<?> message) {
        try {
            return this.transformer.transform(message);
        }
        catch (Exception e) {
            if (e instanceof MessageTransformationException) {
                throw (MessageTransformationException)e;
            }
            throw new MessageTransformationException(message, (Throwable)e);
        }
    }

    @Override
    protected boolean shouldCopyRequestHeaders() {
        return false;
    }
}

