/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.context.expression.MapAccessor;
import org.springframework.core.convert.ConversionService;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.Message;
import org.springframework.integration.MessageHandlingException;
import org.springframework.integration.util.BeanFactoryTypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExpressionEvaluator
implements BeanFactoryAware {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final StandardEvaluationContext evaluationContext = new StandardEvaluationContext();
    private final ExpressionParser expressionParser = new SpelExpressionParser();
    private final BeanFactoryTypeConverter typeConverter = new BeanFactoryTypeConverter();
    private volatile BeanResolver beanResolver;

    public AbstractExpressionEvaluator() {
        this.evaluationContext.setTypeConverter((TypeConverter)this.typeConverter);
        this.evaluationContext.addPropertyAccessor((PropertyAccessor)new MapAccessor());
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        if (beanFactory != null) {
            this.typeConverter.setBeanFactory(beanFactory);
            if (this.beanResolver == null) {
                this.evaluationContext.setBeanResolver((BeanResolver)new BeanFactoryResolver(beanFactory));
            }
        }
    }

    public void setBeanResolver(BeanResolver beanResolver) {
        this.beanResolver = beanResolver;
        this.evaluationContext.setBeanResolver(beanResolver);
    }

    public void setConversionService(ConversionService conversionService) {
        if (conversionService != null) {
            this.typeConverter.setConversionService(conversionService);
        }
    }

    protected StandardEvaluationContext getEvaluationContext() {
        return this.evaluationContext;
    }

    protected <T> T evaluateExpression(Expression expression, Message<?> message, Class<T> expectedType) {
        try {
            return this.evaluateExpression(expression, (Object)message, expectedType);
        }
        catch (EvaluationException e) {
            Throwable cause = e.getCause();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"SpEL Expression evaluation failed with EvaluationException.", (Throwable)e);
            }
            throw new MessageHandlingException(message, "Expression evaluation failed: " + expression.getExpressionString(), cause == null ? e : cause);
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("SpEL Expression evaluation failed with Exception." + e));
            }
            throw new MessageHandlingException(message, "Expression evaluation failed: " + expression.getExpressionString(), e);
        }
    }

    protected Object evaluateExpression(String expression, Object input) {
        return this.evaluateExpression(expression, input, (Class)null);
    }

    protected <T> T evaluateExpression(String expression, Object input, Class<T> expectedType) {
        return (T)this.expressionParser.parseExpression(expression).getValue((EvaluationContext)this.evaluationContext, input, expectedType);
    }

    protected Object evaluateExpression(Expression expression, Object input) {
        return this.evaluateExpression(expression, input, (Class)null);
    }

    protected <T> T evaluateExpression(Expression expression, Class<T> expectedType) {
        return (T)expression.getValue((EvaluationContext)this.evaluationContext, expectedType);
    }

    protected Object evaluateExpression(Expression expression) {
        return expression.getValue((EvaluationContext)this.evaluationContext);
    }

    protected <T> T evaluateExpression(Expression expression, Object input, Class<T> expectedType) {
        return (T)expression.getValue((EvaluationContext)this.evaluationContext, input, expectedType);
    }
}

