/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.util;

import java.beans.PropertyEditor;
import org.springframework.beans.BeansException;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.support.ConversionServiceFactory;
import org.springframework.expression.TypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanFactoryTypeConverter
implements TypeConverter,
BeanFactoryAware {
    private static ConversionService defaultConversionService;
    private volatile SimpleTypeConverter delegate = new SimpleTypeConverter();
    private volatile ConversionService conversionService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeanFactoryTypeConverter() {
        Class<BeanFactoryTypeConverter> clazz = BeanFactoryTypeConverter.class;
        synchronized (BeanFactoryTypeConverter.class) {
            if (defaultConversionService == null) {
                defaultConversionService = ConversionServiceFactory.createDefaultConversionService();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.conversionService = defaultConversionService;
            return;
        }
    }

    public BeanFactoryTypeConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        org.springframework.beans.TypeConverter typeConverter;
        if (beanFactory instanceof ConfigurableBeanFactory && (typeConverter = ((ConfigurableBeanFactory)beanFactory).getTypeConverter()) instanceof SimpleTypeConverter) {
            this.delegate = (SimpleTypeConverter)typeConverter;
        }
    }

    public boolean canConvert(Class<?> sourceType, Class<?> targetType) {
        if (this.conversionService.canConvert(sourceType, targetType)) {
            return true;
        }
        if (!String.class.isAssignableFrom(sourceType) && !String.class.isAssignableFrom(targetType)) {
            return false;
        }
        if (!String.class.isAssignableFrom(sourceType)) {
            return this.delegate.findCustomEditor(sourceType, null) != null || this.delegate.getDefaultEditor(sourceType) != null;
        }
        return this.delegate.findCustomEditor(targetType, null) != null || this.delegate.getDefaultEditor(targetType) != null;
    }

    public boolean canConvert(TypeDescriptor sourceTypeDescriptor, TypeDescriptor targetTypeDescriptor) {
        if (this.conversionService.canConvert(sourceTypeDescriptor, targetTypeDescriptor)) {
            return true;
        }
        Class sourceType = sourceTypeDescriptor.getObjectType();
        Class targetType = targetTypeDescriptor.getObjectType();
        return this.canConvert(sourceType, targetType);
    }

    public Object convertValue(Object value, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if ((targetType.getType() == Void.class || targetType.getType() == Void.TYPE) && value == null) {
            return null;
        }
        if (this.conversionService.canConvert(sourceType, targetType)) {
            return this.conversionService.convert(value, sourceType, targetType);
        }
        if (!String.class.isAssignableFrom(sourceType.getType())) {
            PropertyEditor editor = this.delegate.findCustomEditor(sourceType.getType(), null);
            if (editor == null) {
                editor = this.delegate.getDefaultEditor(sourceType.getType());
            }
            if (editor != null) {
                editor.setValue(value);
                String text = editor.getAsText();
                if (String.class.isAssignableFrom(targetType.getClass())) {
                    return text;
                }
                return this.convertValue(text, TypeDescriptor.valueOf(String.class), targetType);
            }
        }
        return this.delegate.convertIfNecessary(value, targetType.getType());
    }
}

