/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.util;

import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassUtils {
    public static Class<?> findClosestMatch(Class<?> type, Set<Class<?>> candidates, boolean failOnTie) {
        int minTypeDiffWeight = Integer.MAX_VALUE;
        Class<?> closestMatch = null;
        for (Class<?> candidate : candidates) {
            int typeDiffWeight = ClassUtils.getTypeDifferenceWeight(candidate, type);
            if (typeDiffWeight < minTypeDiffWeight) {
                minTypeDiffWeight = typeDiffWeight;
                closestMatch = candidate;
                continue;
            }
            if (!failOnTie || typeDiffWeight >= Integer.MAX_VALUE || typeDiffWeight != minTypeDiffWeight) continue;
            throw new IllegalStateException("Unresolvable ambiguity while attempting to find closest match for [" + type.getName() + "]. Candidate types [" + closestMatch.getName() + "] and [" + candidate.getName() + "] have equal weight.");
        }
        return closestMatch;
    }

    private static int getTypeDifferenceWeight(Class<?> candidate, Class<?> type) {
        int result = 0;
        if (!org.springframework.util.ClassUtils.isAssignable(candidate, type)) {
            return Integer.MAX_VALUE;
        }
        Class<?> superClass = type.getSuperclass();
        while (superClass != null) {
            if (type.equals(superClass)) {
                result += 2;
                superClass = null;
                continue;
            }
            if (org.springframework.util.ClassUtils.isAssignable(candidate, superClass)) {
                result += 2;
                superClass = superClass.getSuperclass();
                continue;
            }
            superClass = null;
        }
        if (candidate.isInterface()) {
            ++result;
        }
        return result;
    }
}

