/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cometd;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Message;
import org.apache.camel.impl.DefaultMessage;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.server.BayeuxServerImpl;

public class CometdBinding {
    public static final String HEADERS_FIELD = "CamelHeaders";
    public static final String COMETD_CLIENT_ID_HEADER_NAME = "CometdClientId";
    public static final String SUBSCRIPTION_HEADER_NAME = "subscription";
    private final BayeuxServerImpl bayeux;

    public CometdBinding(BayeuxServerImpl bayeux) {
        this.bayeux = bayeux;
    }

    public ServerMessage.Mutable createCometdMessage(ServerChannel channel, ServerSession serverSession, Message camelMessage) {
        ServerMessage.Mutable mutable = this.bayeux.newMessage();
        mutable.setChannel(channel.getId());
        if (serverSession != null) {
            mutable.setClientId(serverSession.getId());
        }
        this.addHeadersToMessage(mutable, camelMessage);
        mutable.setData(camelMessage.getBody());
        return mutable;
    }

    public Message createCamelMessage(ServerSession remote, ServerMessage cometdMessage, Object data) {
        if (cometdMessage != null) {
            data = cometdMessage.getData();
        }
        DefaultMessage message = new DefaultMessage();
        message.setBody(data);
        message.setHeaders(this.getHeadersFromMessage(cometdMessage));
        message.setHeader(COMETD_CLIENT_ID_HEADER_NAME, (Object)remote.getId());
        if (cometdMessage.get((Object)SUBSCRIPTION_HEADER_NAME) != null) {
            message.setHeader(SUBSCRIPTION_HEADER_NAME, cometdMessage.get((Object)SUBSCRIPTION_HEADER_NAME));
        }
        return message;
    }

    public void addHeadersToMessage(ServerMessage.Mutable cometdMessage, Message camelMessage) {
        if (camelMessage.hasHeaders()) {
            Map ext = cometdMessage.getExt(true);
            ext.put(HEADERS_FIELD, this.filterHeaders(camelMessage.getHeaders()));
        }
    }

    private Object filterHeaders(Map<String, Object> headers) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            if (entry == null || entry.getKey() == null) continue;
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    private Map<String, Object> getHeadersFromMessage(ServerMessage message) {
        Map ext = message.getExt();
        if (ext != null && ext.containsKey(HEADERS_FIELD)) {
            return (Map)ext.get(HEADERS_FIELD);
        }
        return null;
    }
}

