/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.krati;

import java.util.LinkedList;
import java.util.Queue;
import krati.store.DataStore;
import krati.util.IndexedIterator;
import org.apache.camel.BatchConsumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.component.krati.KratiEndpoint;
import org.apache.camel.impl.ScheduledPollConsumer;
import org.apache.camel.spi.ShutdownAware;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KratiConsumer
extends ScheduledPollConsumer
implements BatchConsumer,
ShutdownAware {
    private static final transient Logger LOG = LoggerFactory.getLogger(KratiConsumer.class);
    protected final KratiEndpoint endpoint;
    protected DataStore dataStore;
    protected int maxMessagesPerPoll = 10;
    protected volatile ShutdownRunningTask shutdownRunningTask;
    protected volatile int pendingExchanges;

    public KratiConsumer(KratiEndpoint endpoint, Processor processor, DataStore dataStore) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.dataStore = dataStore;
    }

    protected int poll() throws Exception {
        this.shutdownRunningTask = null;
        this.pendingExchanges = 0;
        LinkedList<Exchange> queue = new LinkedList<Exchange>();
        IndexedIterator keyIterator = this.dataStore.keyIterator();
        while (keyIterator.hasNext()) {
            Object key = keyIterator.next();
            Object value = this.dataStore.get(key);
            Exchange exchange = this.endpoint.createExchange();
            exchange.setProperty("CamelKratiKey", key);
            exchange.getIn().setBody(value);
            queue.add(exchange);
        }
        return queue.isEmpty() ? 0 : this.processBatch(CastUtils.cast(queue));
    }

    public void setMaxMessagesPerPoll(int maxMessagesPerPoll) {
        this.maxMessagesPerPoll = maxMessagesPerPoll;
    }

    public int processBatch(Queue<Object> exchanges) throws Exception {
        int total = exchanges.size();
        for (int index = 0; index < total && this.isBatchAllowed(); ++index) {
            Exchange exchange = (Exchange)ObjectHelper.cast(Exchange.class, (Object)exchanges.poll());
            exchange.setProperty("CamelBatchIndex", (Object)index);
            exchange.setProperty("CamelBatchSize", (Object)total);
            exchange.setProperty("CamelBatchComplete", (Object)(index == total - 1 ? 1 : 0));
            this.pendingExchanges = total - index - 1;
            exchange.addOnCompletion(new Synchronization(){

                public void onComplete(Exchange exchange) {
                    try {
                        KratiConsumer.this.dataStore.delete(exchange.getProperty("CamelKratiKey"));
                    }
                    catch (Exception e) {
                        LOG.warn("Failed to remove from datastore.", (Throwable)e);
                    }
                }

                public void onFailure(Exchange exchange) {
                }
            });
            LOG.trace("Processing exchange [{}]...", (Object)exchange);
            this.getProcessor().process(exchange);
        }
        return total;
    }

    public boolean isBatchAllowed() {
        boolean answer = this.isRunAllowed();
        if (!answer) {
            return false;
        }
        if (this.shutdownRunningTask == null) {
            return true;
        }
        return ShutdownRunningTask.CompleteAllTasks == this.shutdownRunningTask;
    }

    public boolean deferShutdown(ShutdownRunningTask shutdownRunningTask) {
        this.shutdownRunningTask = shutdownRunningTask;
        return false;
    }

    public int getPendingExchangesSize() {
        int answer = ShutdownRunningTask.CompleteAllTasks == this.shutdownRunningTask ? this.pendingExchanges : 0;
        if (answer == 0 && this.isPolling()) {
            this.log.trace("Currently polling so returning 1 as pending exchanges");
            answer = 1;
        }
        return answer;
    }

    public void prepareShutdown(boolean forced) {
    }
}

