/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.krati.processor.idempotent;

import krati.core.segment.ChannelSegmentFactory;
import krati.core.segment.SegmentFactory;
import krati.io.Serializer;
import krati.store.DataSet;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.component.krati.KratiHelper;
import org.apache.camel.component.krati.serializer.KratiDefaultSerializer;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.support.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KratiIdempotentRepository
extends ServiceSupport
implements IdempotentRepository<String> {
    private static final transient Logger LOG = LoggerFactory.getLogger(KratiHelper.class);
    private String repositoryPath;
    private DataSet dataSet;
    private int initialCapacity = 100;
    private Serializer serializer = new KratiDefaultSerializer();
    private SegmentFactory segmentFactory = new ChannelSegmentFactory();

    public KratiIdempotentRepository(String repositoryPath) {
        this.repositoryPath = repositoryPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation(description="Adds the key to the store")
    public boolean add(String s) {
        byte[] bytes = this.serializer.serialize((Object)s);
        try {
            DataSet dataSet = this.dataSet;
            synchronized (dataSet) {
                if (this.dataSet.has((Object)bytes)) {
                    return false;
                }
                return this.dataSet.add((Object)this.serializer.serialize((Object)s));
            }
        }
        catch (Exception e) {
            LOG.warn("Error adding item to krati idempotent repository. This exception is ignored.", (Throwable)e);
            return false;
        }
    }

    @ManagedOperation(description="Does the store contain the given key")
    public boolean contains(String s) {
        byte[] bytes = this.serializer.serialize((Object)s);
        try {
            return this.dataSet.has((Object)bytes);
        }
        catch (Exception e) {
            LOG.warn("Error checking item exists in krati idempotent repository. This exception is ignored.", (Throwable)e);
            return false;
        }
    }

    @ManagedOperation(description="Does the store contain the given key")
    public boolean remove(String s) {
        byte[] bytes = this.serializer.serialize((Object)s);
        try {
            return this.dataSet.delete((Object)bytes);
        }
        catch (Exception e) {
            LOG.warn("Error removing item from krati idempotent repository. This exception is ignored.", (Throwable)e);
            return false;
        }
    }

    public boolean confirm(String s) {
        return true;
    }

    protected void doStart() throws Exception {
        if (this.dataSet == null) {
            this.dataSet = KratiHelper.createDataSet(this.repositoryPath, this.initialCapacity, this.segmentFactory);
        }
    }

    protected void doStop() throws Exception {
        if (this.dataSet != null && this.dataSet.isOpen()) {
            this.dataSet.close();
        }
    }

    public String getRepositoryPath() {
        return this.repositoryPath;
    }

    public void setRepositoryPath(String repositoryPath) {
        this.repositoryPath = repositoryPath;
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
    }

    public int getInitialCapacity() {
        return this.initialCapacity;
    }

    public void setInitialCapacity(int initialCapacity) {
        this.initialCapacity = initialCapacity;
    }

    public Serializer getSerializer() {
        return this.serializer;
    }

    public void setSerializer(Serializer serializer) {
        this.serializer = serializer;
    }

    public SegmentFactory getSegmentFactory() {
        return this.segmentFactory;
    }

    public void setSegmentFactory(SegmentFactory segmentFactory) {
        this.segmentFactory = segmentFactory;
    }
}

