/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2;

import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.jclouds.aws.domain.Region;
import org.jclouds.ec2.EC2PropertiesBuilder;

public class AWSEC2PropertiesBuilder
extends EC2PropertiesBuilder {
    protected Properties defaultProperties() {
        Properties properties = super.defaultProperties();
        properties.setProperty("jclouds.compute.timeout.node-suspended", "120000");
        properties.setProperty("jclouds.ssh.max-retries", "7");
        properties.setProperty("jclouds.ssh.retry-auth", "true");
        properties.setProperty("jclouds.endpoint", "https://ec2.us-east-1.amazonaws.com");
        properties.setProperty("jclouds.ec2.generate-instance-names", "true");
        properties.putAll((Map<?, ?>)Region.regionProperties());
        properties.remove("jclouds.ec2.ami-owners");
        properties.setProperty("jclouds.ec2.ami-query", "owner-id=137112412989,063491364108,099720109477,411009282317;state=available;image-type=machine");
        properties.setProperty("jclouds.ec2.cc-regions", "us-east-1");
        properties.setProperty("jclouds.ec2.cc-ami-query", "virtualization-type=hvm;architecture=x86_64;owner-id=137112412989,099720109477;hypervisor=xen;state=available;image-type=machine;root-device-type=ebs");
        return properties;
    }

    public AWSEC2PropertiesBuilder() {
    }

    public AWSEC2PropertiesBuilder(Properties properties) {
        super(properties);
    }

    public Properties build() {
        Properties props = super.build();
        this.warnAndReplaceIfUsingOldImageKey(props);
        return props;
    }

    protected void warnAndReplaceIfUsingOldImageKey(Properties props) {
        if (props.containsKey("jclouds.ec2.ami-owners")) {
            StringBuilder query = new StringBuilder();
            String owners = this.properties.remove("jclouds.ec2.ami-owners").toString();
            if ("*".equals(owners)) {
                query.append("state=available;image-type=machine");
            } else if (!"".equals(owners)) {
                query.append("owner-id=").append(owners).append(";state=available;image-type=machine");
            } else if ("".equals(owners)) {
                query = new StringBuilder();
            }
            props.setProperty("jclouds.ec2.ami-query", query.toString());
            Logger.getAnonymousLogger().warning(String.format("Property %s is deprecated, please use new syntax: %s=%s", "jclouds.ec2.ami-owners", "jclouds.ec2.ami-query", query.toString()));
        }
    }
}

