/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.config;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Sets;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.AWSEC2AsyncClient;
import org.jclouds.aws.ec2.AWSEC2Client;
import org.jclouds.aws.ec2.compute.AWSEC2ComputeService;
import org.jclouds.aws.ec2.compute.AWSEC2TemplateOptions;
import org.jclouds.aws.ec2.compute.config.ClusterCompute;
import org.jclouds.aws.ec2.compute.suppliers.CallForImages;
import org.jclouds.aws.ec2.domain.PlacementGroup;
import org.jclouds.aws.ec2.domain.RegionNameAndPublicKeyMaterial;
import org.jclouds.aws.ec2.functions.CreatePlacementGroupIfNeeded;
import org.jclouds.aws.ec2.functions.ImportOrReturnExistingKeypair;
import org.jclouds.aws.ec2.predicates.PlacementGroupAvailable;
import org.jclouds.aws.ec2.predicates.PlacementGroupDeleted;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.internal.ComputeServiceContextImpl;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.Credentials;
import org.jclouds.ec2.compute.config.EC2ComputeServiceDependenciesModule;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.functions.CreateSecurityGroupIfNeeded;
import org.jclouds.ec2.compute.functions.CreateUniqueKeyPair;
import org.jclouds.ec2.compute.functions.CredentialsForInstance;
import org.jclouds.ec2.compute.functions.LoadPublicIpForInstanceOrNull;
import org.jclouds.ec2.compute.functions.RegionAndIdToImage;
import org.jclouds.ec2.compute.internal.EC2TemplateBuilderImpl;
import org.jclouds.ec2.domain.KeyPair;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.predicates.RetryablePredicate;
import org.jclouds.rest.RestContext;
import org.jclouds.rest.internal.RestContextImpl;

public class AWSEC2ComputeServiceDependenciesModule
extends EC2ComputeServiceDependenciesModule {
    protected void configure() {
        this.bind(TemplateBuilder.class).to(EC2TemplateBuilderImpl.class);
        this.bind(TemplateOptions.class).to(AWSEC2TemplateOptions.class);
        this.bind(ComputeService.class).to(AWSEC2ComputeService.class);
        this.bind((TypeLiteral)new TypeLiteral<CacheLoader<RunningInstance, Credentials>>(){}).to(CredentialsForInstance.class);
        this.bind((TypeLiteral)new TypeLiteral<CacheLoader<RegionAndName, String>>(){}).annotatedWith((Annotation)Names.named((String)"SECURITY")).to(CreateSecurityGroupIfNeeded.class);
        this.bind((TypeLiteral)new TypeLiteral<CacheLoader<RegionAndName, String>>(){}).annotatedWith((Annotation)Names.named((String)"ELASTICIP")).to(LoadPublicIpForInstanceOrNull.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<RegionAndName, KeyPair>>(){}).to(CreateUniqueKeyPair.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<RegionNameAndPublicKeyMaterial, KeyPair>>(){}).to(ImportOrReturnExistingKeypair.class);
        this.bind((TypeLiteral)new TypeLiteral<CacheLoader<RegionAndName, Image>>(){}).to(RegionAndIdToImage.class);
        this.bind((TypeLiteral)new TypeLiteral<ComputeServiceContext>(){}).to((TypeLiteral)new TypeLiteral<ComputeServiceContextImpl<AWSEC2Client, AWSEC2AsyncClient>>(){}).in(Scopes.SINGLETON);
        this.bind((TypeLiteral)new TypeLiteral<RestContext<AWSEC2Client, AWSEC2AsyncClient>>(){}).to((TypeLiteral)new TypeLiteral<RestContextImpl<AWSEC2Client, AWSEC2AsyncClient>>(){}).in(Scopes.SINGLETON);
        this.install(new FactoryModuleBuilder().build(CallForImages.Factory.class));
    }

    @Provides
    @Singleton
    @Named(value="AVAILABLE")
    protected Predicate<PlacementGroup> placementGroupAvailable(PlacementGroupAvailable available) {
        return new RetryablePredicate((Predicate)available, 60L, 1L, TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    @Named(value="DELETED")
    protected Predicate<PlacementGroup> placementGroupDeleted(PlacementGroupDeleted deleted) {
        return new RetryablePredicate((Predicate)deleted, 60L, 1L, TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    @Named(value="PLACEMENT")
    protected LoadingCache<RegionAndName, String> placementGroupMap(CreatePlacementGroupIfNeeded in) {
        return CacheBuilder.newBuilder().build((CacheLoader)in);
    }

    @Provides
    @ClusterCompute
    @Singleton
    protected Set<String> provideClusterComputeIds() {
        return Sets.newLinkedHashSet();
    }
}

