/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.sql;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.kernel.exps.FilterValue;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.PrimaryKey;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.schema.Unique;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.util.OpenJPAException;
import org.apache.openjpa.util.ReferentialIntegrityException;

public class HSQLDictionary
extends DBDictionary {
    public boolean cacheTables = false;
    private int dbMajorVersion;
    private SQLBuffer _oneBuffer = new SQLBuffer(this).append("1");

    public HSQLDictionary() {
        this.platform = "HSQL";
        this.validationSQL = "CALL 1";
        this.concatenateFunction = "CONCAT({0},{1})";
        this.closePoolSQL = "SHUTDOWN";
        this.supportsAutoAssign = true;
        this.lastGeneratedKeyQuery = "CALL IDENTITY()";
        this.autoAssignClause = "IDENTITY";
        this.autoAssignTypeName = "INTEGER";
        this.nextSequenceQuery = "SELECT NEXT VALUE FOR {0} FROM INFORMATION_SCHEMA.SYSTEM_SEQUENCES";
        this.crossJoinClause = "JOIN";
        this.requiresConditionForCrossJoin = true;
        this.stringLengthFunction = "LENGTH({0})";
        this.trimLeadingFunction = "LTRIM({0})";
        this.trimTrailingFunction = "RTRIM({0})";
        this.trimBothFunction = "LTRIM(RTRIM({0}))";
        this.supportsSelectForUpdate = false;
        this.supportsSelectStartIndex = true;
        this.supportsSelectEndIndex = true;
        this.supportsDeferredConstraints = false;
        this.doubleTypeName = "NUMERIC";
        this.supportsNullTableForGetPrimaryKeys = true;
        this.supportsNullTableForGetIndexInfo = true;
        this.requiresCastForMathFunctions = true;
        this.requiresCastForComparisons = true;
        this.reservedWordSet.addAll(Arrays.asList("BEFORE", "BIGINT", "BINARY", "CACHED", "DATETIME", "LIMIT", "LONGVARBINARY", "LONGVARCHAR", "OBJECT", "OTHER", "SAVEPOINT", "TEMP", "TEXT", "TRIGGER", "TINYINT", "VARBINARY", "VARCHAR_IGNORECASE"));
    }

    @Override
    public void connectedConfiguration(Connection conn) throws SQLException {
        super.connectedConfiguration(conn);
        this.determineHSQLDBVersion(conn);
        if (this.dbMajorVersion == 1) {
            this.blobTypeName = "VARBINARY";
            this.useGetObjectForBlobs = true;
            this.rangePosition = 1;
            this.useSchemaName = false;
        }
    }

    protected void determineHSQLDBVersion(Connection con) throws SQLException {
        DatabaseMetaData metaData = con.getMetaData();
        if (this.isJDBC3) {
            this.dbMajorVersion = metaData.getDatabaseMajorVersion();
        } else {
            String productVersion = metaData.getDatabaseProductVersion();
            String[] version = productVersion.split("\\.");
            this.dbMajorVersion = Integer.parseInt(version[0]);
        }
    }

    @Override
    public int getJDBCType(int metaTypeCode, boolean lob) {
        int type = super.getJDBCType(metaTypeCode, lob);
        switch (type) {
            case -5: {
                if (metaTypeCode != 25) break;
                return 2;
            }
        }
        return type;
    }

    @Override
    public int getPreferredType(int type) {
        if (this.dbMajorVersion > 1) {
            return super.getPreferredType(type);
        }
        switch (type) {
            case 2005: {
                return 12;
            }
            case 2004: {
                return -3;
            }
        }
        return super.getPreferredType(type);
    }

    @Override
    public String[] getAddPrimaryKeySQL(PrimaryKey pk) {
        return new String[0];
    }

    @Override
    public String[] getDropPrimaryKeySQL(PrimaryKey pk) {
        return new String[0];
    }

    @Override
    public String[] getAddColumnSQL(Column column) {
        return new String[]{"ALTER TABLE " + this.getFullName(column.getTable(), false) + " ADD COLUMN " + this.getDeclareColumnSQL(column, true)};
    }

    @Override
    public String[] getCreateTableSQL(Table table) {
        String pkStr;
        StringBuilder buf = new StringBuilder();
        buf.append("CREATE ");
        if (this.cacheTables) {
            buf.append("CACHED ");
        }
        buf.append("TABLE ").append(this.getFullName(table, false)).append(" (");
        Column[] cols = table.getColumns();
        for (int i = 0; i < cols.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.getDeclareColumnSQL(cols[i], false));
        }
        PrimaryKey pk = table.getPrimaryKey();
        if (pk != null && !StringUtils.isEmpty((String)(pkStr = this.getPrimaryKeyConstraintSQL(pk)))) {
            buf.append(", ").append(pkStr);
        }
        Unique[] unqs = table.getUniques();
        for (int i = 0; i < unqs.length; ++i) {
            String unqStr = this.getUniqueConstraintSQL(unqs[i]);
            if (unqStr == null) continue;
            buf.append(", ").append(unqStr);
        }
        buf.append(")");
        return new String[]{buf.toString()};
    }

    @Override
    protected String getPrimaryKeyConstraintSQL(PrimaryKey pk) {
        Column[] cols = pk.getColumns();
        if (cols.length == 1 && cols[0].isAutoAssigned()) {
            return null;
        }
        return super.getPrimaryKeyConstraintSQL(pk);
    }

    @Override
    public boolean isSystemIndex(String name, Table table) {
        return name.toUpperCase().startsWith("SYS_");
    }

    @Override
    public boolean isSystemIndex(DBIdentifier name, Table table) {
        if (DBIdentifier.isNull(name)) {
            return false;
        }
        return name.getName().toUpperCase().startsWith("SYS_");
    }

    @Override
    protected String getSequencesSQL(String schemaName, String sequenceName) {
        StringBuilder buf = new StringBuilder();
        buf.append("SELECT SEQUENCE_SCHEMA, SEQUENCE_NAME FROM ").append("INFORMATION_SCHEMA.SYSTEM_SEQUENCES");
        if (schemaName != null || sequenceName != null) {
            buf.append(" WHERE ");
        }
        if (schemaName != null) {
            buf.append("SEQUENCE_SCHEMA = ?");
            if (sequenceName != null) {
                buf.append(" AND ");
            }
        }
        if (sequenceName != null) {
            buf.append("SEQUENCE_NAME = ?");
        }
        return buf.toString();
    }

    @Override
    public SQLBuffer toOperation(String op, SQLBuffer selects, SQLBuffer from, SQLBuffer where, SQLBuffer group, SQLBuffer having, SQLBuffer order, boolean distinct, long start, long end, String forUpdateClause) {
        if (!(start == 0L && end == Long.MAX_VALUE || order != null && !order.isEmpty())) {
            order = this._oneBuffer;
        }
        return super.toOperation(op, selects, from, where, group, having, order, distinct, start, end, forUpdateClause);
    }

    @Override
    public Column[] getColumns(DatabaseMetaData meta, String catalog, String schemaName, String tableName, String columnName, Connection conn) throws SQLException {
        Column[] cols = super.getColumns(meta, catalog, schemaName, tableName, columnName, conn);
        for (int i = 0; cols != null && i < cols.length; ++i) {
            if (!"BOOLEAN".equalsIgnoreCase(cols[i].getTypeIdentifier().getName())) continue;
            cols[i].setType(-7);
        }
        return cols;
    }

    @Override
    public void setDouble(PreparedStatement stmnt, int idx, double val, Column col) throws SQLException {
        if (val == 9.223372036854776E18 || val == -9.223372036854776E18) {
            stmnt.setLong(idx, (long)val);
        } else {
            super.setDouble(stmnt, idx, val, col);
        }
    }

    @Override
    public void setBigDecimal(PreparedStatement stmnt, int idx, BigDecimal val, Column col) throws SQLException {
        int type = val == null || col == null ? 24 : col.getJavaType();
        switch (type) {
            case 3: 
            case 19: {
                this.setDouble(stmnt, idx, val.doubleValue(), col);
                break;
            }
            case 4: 
            case 20: {
                this.setDouble(stmnt, idx, val.floatValue(), col);
                break;
            }
            default: {
                super.setBigDecimal(stmnt, idx, val, col);
            }
        }
    }

    @Override
    protected void appendSelectRange(SQLBuffer buf, long start, long end, boolean subselect) {
        if (this.dbMajorVersion > 1) {
            if (start != 0L) {
                buf.append(" OFFSET ").appendValue(start);
            }
            if (end != Long.MAX_VALUE) {
                buf.append(" LIMIT ").appendValue(end - start);
            }
            return;
        }
        buf.append(" LIMIT ").append(String.valueOf(start)).append(" ");
        if (end == Long.MAX_VALUE) {
            buf.append(String.valueOf(0));
        } else {
            buf.append(String.valueOf(end - start));
        }
    }

    @Override
    public void indexOf(SQLBuffer buf, FilterValue str, FilterValue find, FilterValue start) {
        buf.append("(LOCATE(");
        find.appendTo(buf);
        buf.append(", ");
        str.appendTo(buf);
        if (start != null) {
            buf.append(", (");
            start.appendTo(buf);
            buf.append(" + 1)");
        }
        buf.append(") - 1)");
    }

    @Override
    public String getPlaceholderValueString(Column col) {
        String type = this.getTypeName(col.getType());
        int idx = type.indexOf("{0}");
        if (idx != -1) {
            String pre = type.substring(0, idx);
            type = type.length() > idx + 3 ? pre + type.substring(idx + 3) : pre;
        }
        return "NULL AS " + type;
    }

    @Override
    public OpenJPAException newStoreException(String msg, SQLException[] causes, Object failed) {
        OpenJPAException ke = super.newStoreException(msg, causes, failed);
        if (ke instanceof ReferentialIntegrityException && causes[0].getErrorCode() == -9) {
            ((ReferentialIntegrityException)ke).setIntegrityViolation(2);
        }
        return ke;
    }
}

