/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.axiom;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.springframework.ws.soap.SoapHeader;
import org.springframework.ws.soap.SoapHeaderElement;
import org.springframework.ws.soap.SoapHeaderException;
import org.springframework.ws.soap.axiom.AxiomResult;
import org.springframework.ws.soap.axiom.AxiomSoapElement;
import org.springframework.ws.soap.axiom.AxiomSoapHeaderElement;
import org.springframework.ws.soap.axiom.AxiomSoapHeaderException;
import org.springframework.xml.namespace.QNameUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AxiomSoapHeader
extends AxiomSoapElement
implements SoapHeader {
    AxiomSoapHeader(SOAPHeader axiomHeader, SOAPFactory axiomFactory) {
        super((OMElement)axiomHeader, axiomFactory);
    }

    @Override
    public Result getResult() {
        return new AxiomResult((OMContainer)this.getAxiomHeader(), (OMFactory)this.getAxiomFactory());
    }

    @Override
    public SoapHeaderElement addHeaderElement(QName name) {
        try {
            OMNamespace namespace = this.getAxiomFactory().createOMNamespace(name.getNamespaceURI(), QNameUtils.getPrefix((QName)name));
            SOAPHeaderBlock axiomHeaderBlock = this.getAxiomHeader().addHeaderBlock(name.getLocalPart(), namespace);
            return new AxiomSoapHeaderElement(axiomHeaderBlock, this.getAxiomFactory());
        }
        catch (OMException ex) {
            throw new AxiomSoapHeaderException(ex);
        }
    }

    @Override
    public void removeHeaderElement(QName name) throws SoapHeaderException {
        try {
            OMElement element = this.getAxiomHeader().getFirstChildWithName(name);
            if (element != null) {
                element.detach();
            }
        }
        catch (OMException ex) {
            throw new AxiomSoapHeaderException(ex);
        }
    }

    @Override
    public Iterator<SoapHeaderElement> examineMustUnderstandHeaderElements(String role) {
        try {
            return new AxiomSoapHeaderElementIterator(this.getAxiomHeader().examineMustUnderstandHeaderBlocks(role));
        }
        catch (OMException ex) {
            throw new AxiomSoapHeaderException(ex);
        }
    }

    @Override
    public Iterator<SoapHeaderElement> examineAllHeaderElements() {
        try {
            return new AxiomSoapHeaderElementIterator(this.getAxiomHeader().examineAllHeaderBlocks());
        }
        catch (OMException ex) {
            throw new AxiomSoapHeaderException(ex);
        }
    }

    @Override
    public Iterator<SoapHeaderElement> examineHeaderElements(QName name) throws SoapHeaderException {
        try {
            return new AxiomSoapHeaderElementIterator(this.getAxiomHeader().getChildrenWithName(name));
        }
        catch (OMException ex) {
            throw new AxiomSoapHeaderException(ex);
        }
    }

    protected SOAPHeader getAxiomHeader() {
        return (SOAPHeader)this.getAxiomElement();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AxiomSoapHeaderElementIterator
    implements Iterator<SoapHeaderElement> {
        private final Iterator<SOAPHeaderBlock> axiomIterator;

        protected AxiomSoapHeaderElementIterator(Iterator<SOAPHeaderBlock> axiomIterator) {
            this.axiomIterator = axiomIterator;
        }

        @Override
        public boolean hasNext() {
            return this.axiomIterator.hasNext();
        }

        @Override
        public SoapHeaderElement next() {
            try {
                SOAPHeaderBlock axiomHeaderBlock = this.axiomIterator.next();
                return new AxiomSoapHeaderElement(axiomHeaderBlock, AxiomSoapHeader.this.getAxiomFactory());
            }
            catch (OMException ex) {
                throw new AxiomSoapHeaderException(ex);
            }
        }

        @Override
        public void remove() {
            this.axiomIterator.remove();
        }
    }
}

