/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.config;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Iterables;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import org.jclouds.aws.handlers.AWSClientErrorRetryHandler;
import org.jclouds.aws.handlers.ParseAWSErrorFromXmlContent;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.RequiresHttp;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.Provider;
import org.jclouds.location.Region;
import org.jclouds.location.config.ProvideRegionToURIViaProperties;
import org.jclouds.logging.Logger;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.config.RestClientModule;

@ConfiguresRestClient
@RequiresHttp
public class AWSRestClientModule<S, A>
extends RestClientModule<S, A> {
    public AWSRestClientModule(Class<S> syncClientType, Class<A> asyncClientType, Map<Class<?>, Class<?>> delegates) {
        super(syncClientType, asyncClientType, delegates);
    }

    public AWSRestClientModule(Class<S> syncClientType, Class<A> asyncClientType) {
        super(syncClientType, asyncClientType);
    }

    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(ParseAWSErrorFromXmlContent.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(ParseAWSErrorFromXmlContent.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(ParseAWSErrorFromXmlContent.class);
    }

    protected void bindRetryHandlers() {
        this.bind(HttpRetryHandler.class).annotatedWith(ClientError.class).to(AWSClientErrorRetryHandler.class);
    }

    @Provides
    @Singleton
    @Nullable
    @Region
    protected String getDefaultRegion(@Provider URI uri, @Region Map<String, URI> map, Logger.LoggerFactory logFactory) {
        String region = (String)ImmutableBiMap.copyOf(map).inverse().get((Object)uri);
        if (region == null && map.size() > 0) {
            logFactory.getLogger(((Object)((Object)this)).getClass().getName()).warn("failed to find region for current endpoint %s in %s; choosing first: %s", new Object[]{uri, map, region});
            region = (String)Iterables.get(map.keySet(), (int)0);
        }
        return region;
    }

    protected void bindRegionsToProvider() {
        this.bindRegionsToProvider(ProvideRegionToURIViaProperties.class);
    }

    protected void configure() {
        super.configure();
        this.bindRegionsToProvider();
    }

    protected void bindRegionsToProvider(Class<? extends javax.inject.Provider<Map<String, URI>>> providerClass) {
        this.bind((TypeLiteral)new TypeLiteral<Map<String, URI>>(){}).annotatedWith(Region.class).toProvider(providerClass).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    @Region
    protected Set<String> provideRegions(@Region Map<String, URI> map) {
        return map.keySet();
    }
}

