/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import net.sf.flatpack.AbstractParser;
import net.sf.flatpack.DataSet;
import net.sf.flatpack.DefaultDataSet;
import net.sf.flatpack.structure.Row;
import net.sf.flatpack.util.ParserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDelimiterParser
extends AbstractParser {
    private char delimiter = '\u0000';
    private char qualifier = '\u0000';
    private boolean ignoreFirstRecord = false;
    private int lineCount = 0;
    private final Logger logger = LoggerFactory.getLogger((Class)AbstractDelimiterParser.class);

    public AbstractDelimiterParser(Reader dataSourceReader, String dataDefinition, char delimiter, char qualifier, boolean ignoreFirstRecord) {
        super(dataSourceReader, dataDefinition);
        this.delimiter = delimiter;
        this.qualifier = qualifier;
        this.ignoreFirstRecord = ignoreFirstRecord;
    }

    public AbstractDelimiterParser(Reader dataSourceReader, char delimiter, char qualifier, boolean ignoreFirstRecord) {
        super(dataSourceReader);
        this.delimiter = delimiter;
        this.qualifier = qualifier;
        this.ignoreFirstRecord = ignoreFirstRecord;
    }

    protected DataSet doParse() {
        try {
            this.lineCount = 0;
            return this.doDelimitedFile(this.getDataSourceReader(), this.shouldCreateMDFromFile());
        }
        catch (IOException e) {
            this.logger.error("error accessing/creating inputstream", (Throwable)e);
            return null;
        }
    }

    protected abstract boolean shouldCreateMDFromFile();

    protected char getDelimiter() {
        return this.delimiter;
    }

    protected void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }

    protected boolean isIgnoreFirstRecord() {
        return this.ignoreFirstRecord;
    }

    protected void setIgnoreFirstRecord(boolean ignoreFirstRecord) {
        this.ignoreFirstRecord = ignoreFirstRecord;
    }

    protected char getQualifier() {
        return this.qualifier;
    }

    protected void setQualifier(char qualifier) {
        this.qualifier = qualifier;
    }

    protected int getLineCount() {
        return this.lineCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DataSet doDelimitedFile(Reader dataSource, boolean createMDFromFile) throws IOException {
        if (dataSource == null) {
            throw new NullPointerException("dataSource is null");
        }
        BufferedReader br = null;
        DefaultDataSet ds = new DefaultDataSet(this.getPzMetaData(), this);
        try {
            ds.setPZConvertProps(ParserUtils.loadConvertProperties());
            br = new BufferedReader(dataSource);
            boolean processedFirst = false;
            String line = null;
            while ((line = this.fetchNextRecord(br, this.getQualifier(), this.getDelimiter())) != null) {
                String mdkey;
                List<String> columns;
                block17: {
                    if (!processedFirst && this.isIgnoreFirstRecord()) {
                        processedFirst = true;
                        continue;
                    }
                    if (!processedFirst && createMDFromFile) {
                        processedFirst = true;
                        this.setPzMetaData(ParserUtils.getPZMetaDataFromFile(line, this.delimiter, this.qualifier, this));
                        ds.setMetaData(this.getPzMetaData());
                        continue;
                    }
                    columns = ParserUtils.splitLine(line, this.getDelimiter(), this.getQualifier(), 10);
                    mdkey = ParserUtils.getCMDKeyForDelimitedFile(this.getPzMetaData(), (List)columns);
                    List cmds = ParserUtils.getColumnMetaData(mdkey, this.getPzMetaData());
                    int columnCount = cmds.size();
                    if (columns.size() > columnCount) {
                        if (this.isIgnoreExtraColumns()) {
                            columns = columns.subList(0, columnCount);
                            this.addError(ds, "TRUNCATED LINE TO CORRECT NUMBER OF COLUMNS", this.lineCount, 1);
                            break block17;
                        } else {
                            this.addError(ds, "TOO MANY COLUMNS WANTED: " + columnCount + " GOT: " + columns.size(), this.lineCount, 2, this.isStoreRawDataToDataError() ? line : null);
                            continue;
                        }
                    }
                    if (columns.size() < columnCount) {
                        if (this.isHandlingShortLines()) {
                            while (columns.size() < columnCount) {
                                columns.add("");
                            }
                            this.addError(ds, "PADDED LINE TO CORRECT NUMBER OF COLUMNS", this.lineCount, 1);
                        } else {
                            this.addError(ds, "TOO FEW COLUMNS WANTED: " + columnCount + " GOT: " + columns.size(), this.lineCount, 2, this.isStoreRawDataToDataError() ? line : null);
                            continue;
                        }
                    }
                }
                Row row = new Row();
                row.setMdkey(mdkey.equals("detail") ? null : mdkey);
                row.setCols(columns);
                row.setRowNumber(this.lineCount);
                if (this.isFlagEmptyRows()) {
                    row.setEmpty(ParserUtils.isListElementsEmpty(columns));
                }
                if (this.isStoreRawDataToDataSet()) {
                    row.setRawData(line);
                }
                ds.addRow(row);
            }
            return ds;
        }
        finally {
            if (br != null) {
                br.close();
            }
            this.closeReaders();
        }
    }

    protected String fetchNextRecord(BufferedReader br, char qual, char delim) throws IOException {
        String line = null;
        StringBuffer lineData = new StringBuffer();
        String linebreak = System.getProperty("line.separator");
        boolean processingMultiLine = false;
        while ((line = br.readLine()) != null) {
            ++this.lineCount;
            String trimmed = line.trim();
            int trimmedLen = trimmed.length();
            if (!processingMultiLine && trimmed.length() == 0) continue;
            char[] chrArry = trimmed.toCharArray();
            if (!processingMultiLine && delim > '\u0000') {
                processingMultiLine = ParserUtils.isMultiLine(chrArry, delim, qual);
            }
            String trimmedLineData = lineData.toString().trim();
            if (processingMultiLine && trimmedLineData.length() > 0 && trimmedLen > 0) {
                if (trimmed.charAt(trimmed.length() - 1) == qual && !trimmed.endsWith("" + qual + qual)) {
                    processingMultiLine = false;
                    lineData.append(linebreak).append(line);
                    break;
                }
                lineData.append(linebreak).append(line);
                boolean qualiFound = false;
                for (int i = 0; i < chrArry.length; ++i) {
                    if (qualiFound) {
                        if (chrArry[i] == ' ') continue;
                        if (chrArry[i] == delim) {
                            processingMultiLine = ParserUtils.isMultiLine(chrArry, delim, qual);
                            break;
                        }
                        qualiFound = false;
                        continue;
                    }
                    if (chrArry[i] != qual) continue;
                    qualiFound = true;
                }
                if (!processingMultiLine) break;
                continue;
            }
            lineData.append(trimmedLen == 0 ? linebreak : line);
            if (processingMultiLine) continue;
        }
        if (line == null && lineData.length() == 0) {
            return null;
        }
        return lineData.toString();
    }
}

