/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.flatpack.DataError;
import net.sf.flatpack.DataSet;
import net.sf.flatpack.DefaultDataSet;
import net.sf.flatpack.Parser;
import net.sf.flatpack.util.ParserUtils;
import net.sf.flatpack.xml.MetaData;

public abstract class AbstractParser
implements Parser {
    private boolean handlingShortLines = false;
    private boolean ignoreExtraColumns = false;
    private boolean columnNamesCaseSensitive = false;
    private boolean initialised = false;
    private boolean ignoreParseWarnings = false;
    private boolean nullEmptyStrings = false;
    private MetaData pzMetaData = null;
    private String dataDefinition = null;
    private Reader dataSourceReader = null;
    private List readersToClose = null;
    private boolean flagEmptyRows;
    private boolean storeRawDataToDataError;
    private boolean storeRawDataToDataSet;

    protected AbstractParser(Reader dataSourceReader) {
        this.dataSourceReader = dataSourceReader;
    }

    protected AbstractParser(Reader dataSourceReader, String dataDefinition) {
        this.dataSourceReader = dataSourceReader;
        this.dataDefinition = dataDefinition;
    }

    public boolean isHandlingShortLines() {
        return this.handlingShortLines;
    }

    public void setHandlingShortLines(boolean handleShortLines) {
        this.handlingShortLines = handleShortLines;
    }

    public boolean isIgnoreExtraColumns() {
        return this.ignoreExtraColumns;
    }

    public void setIgnoreExtraColumns(boolean ignoreExtraColumns) {
        this.ignoreExtraColumns = ignoreExtraColumns;
    }

    public final DataSet parse() {
        if (!this.initialised) {
            this.init();
        }
        return this.doParse();
    }

    protected abstract DataSet doParse();

    protected abstract void init();

    protected void closeReaders() throws IOException {
        if (this.readersToClose != null) {
            Iterator readersToCloseIt = this.readersToClose.iterator();
            while (readersToCloseIt.hasNext()) {
                Reader r = (Reader)readersToCloseIt.next();
                r.close();
            }
        }
    }

    protected void addToCloseReaderList(Reader r) {
        if (this.readersToClose == null) {
            this.readersToClose = new ArrayList();
        }
        this.readersToClose.add(r);
    }

    protected void addToMetaData(List columns) {
        if (this.pzMetaData == null) {
            this.pzMetaData = new MetaData(columns, ParserUtils.buidColumnIndexMap(columns, this));
        } else {
            this.pzMetaData.setColumnsNames(columns);
            this.pzMetaData.setColumnIndexMap(ParserUtils.buidColumnIndexMap(columns, this));
        }
    }

    protected boolean isInitialised() {
        return this.initialised;
    }

    protected void setInitialised(boolean initialised) {
        this.initialised = initialised;
    }

    protected String getDataDefinition() {
        return this.dataDefinition;
    }

    protected void setDataDefinition(String dataDefinition) {
        this.dataDefinition = dataDefinition;
    }

    protected void addError(DefaultDataSet ds, String errorDesc, int lineNo, int errorLevel) {
        this.addError(ds, errorDesc, lineNo, errorLevel, null);
    }

    protected void addError(DefaultDataSet ds, String errorDesc, int lineNo, int errorLevel, String lineData) {
        if (errorLevel == 1 && this.isIgnoreParseWarnings()) {
            return;
        }
        DataError de = new DataError(errorDesc, lineNo, errorLevel, lineData);
        ds.addError(de);
    }

    protected Reader getDataSourceReader() {
        return this.dataSourceReader;
    }

    protected void setDataSourceReader(Reader dataSourceReader) {
        this.dataSourceReader = dataSourceReader;
    }

    public boolean isColumnNamesCaseSensitive() {
        return this.columnNamesCaseSensitive;
    }

    public void setColumnNamesCaseSensitive(boolean columnNamesCaseSensitive) {
        this.columnNamesCaseSensitive = columnNamesCaseSensitive;
    }

    public boolean isIgnoreParseWarnings() {
        return this.ignoreParseWarnings;
    }

    public void setIgnoreParseWarnings(boolean ignoreParseWarnings) {
        this.ignoreParseWarnings = ignoreParseWarnings;
    }

    public boolean isNullEmptyStrings() {
        return this.nullEmptyStrings;
    }

    public void setNullEmptyStrings(boolean nullEmptyStrings) {
        this.nullEmptyStrings = nullEmptyStrings;
    }

    public MetaData getPzMetaData() {
        return this.pzMetaData;
    }

    public void setPzMetaData(MetaData pzMap) {
        this.pzMetaData = pzMap;
    }

    public boolean isFlagEmptyRows() {
        return this.flagEmptyRows;
    }

    public void setFlagEmptyRows(boolean flagEmptyRows) {
        this.flagEmptyRows = flagEmptyRows;
    }

    public boolean isStoreRawDataToDataError() {
        return this.storeRawDataToDataError;
    }

    public void setStoreRawDataToDataError(boolean storeRawDataToDataError) {
        this.storeRawDataToDataError = storeRawDataToDataError;
    }

    public boolean isStoreRawDataToDataSet() {
        return this.storeRawDataToDataSet;
    }

    public void setStoreRawDataToDataSet(boolean storeRawDataToDataSet) {
        this.storeRawDataToDataSet = storeRawDataToDataSet;
    }
}

