/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import net.sf.flatpack.AbstractFixedLengthParser;
import net.sf.flatpack.InitialisationException;
import net.sf.flatpack.util.ParserUtils;

public class DBFixedLengthParser
extends AbstractFixedLengthParser {
    private Connection con;
    private InputStream dataSourceStream = null;
    private File dataSource = null;

    public DBFixedLengthParser(Connection con, InputStream dataSourceStream, String dataDefinition) {
        super(null, dataDefinition);
        this.con = con;
        this.dataSourceStream = dataSourceStream;
    }

    public DBFixedLengthParser(Connection con, File dataSource, String dataDefinition) {
        super(null, dataDefinition);
        this.con = con;
        this.dataSource = dataSource;
    }

    public DBFixedLengthParser(Connection con, Reader dataSourceReader, String dataDefinition) {
        super(dataSourceReader, dataDefinition);
        this.con = con;
    }

    protected void init() {
        try {
            InputStreamReader r;
            if (this.dataSourceStream != null) {
                r = new InputStreamReader(this.dataSourceStream);
                this.setDataSourceReader(r);
                this.addToCloseReaderList(r);
            } else if (this.dataSource != null) {
                r = new FileReader(this.dataSource);
                this.setDataSourceReader(r);
                this.addToCloseReaderList(r);
            }
            List cmds = ParserUtils.buildMDFromSQLTable(this.con, this.getDataDefinition());
            this.addToMetaData(cmds);
            if (cmds.isEmpty()) {
                throw new FileNotFoundException("DATA DEFINITION CAN NOT BE FOUND IN THE DATABASE " + this.getDataDefinition());
            }
            this.setInitialised(true);
        }
        catch (SQLException e) {
            throw new InitialisationException(e);
        }
        catch (FileNotFoundException e) {
            throw new InitialisationException(e);
        }
    }
}

