/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.sf.flatpack.AbstractFixedLengthParser;
import net.sf.flatpack.InitialisationException;
import net.sf.flatpack.xml.MapParser;
import org.jdom.JDOMException;

public class FixedLengthParser
extends AbstractFixedLengthParser {
    private InputStream pzmapXMLStream;
    private File pzmapXML;
    private Reader pzmapReader;
    private InputStream dataSourceStream = null;
    private File dataSource = null;

    public FixedLengthParser(InputStream pzmapXMLStream, InputStream dataSourceStream) {
        super(null);
        this.pzmapXMLStream = pzmapXMLStream;
        this.dataSourceStream = dataSourceStream;
    }

    public FixedLengthParser(File pzmapXML, File dataSource) {
        super(null);
        this.pzmapXML = pzmapXML;
        this.dataSource = dataSource;
    }

    public FixedLengthParser(Reader pzmapReader, Reader dataSourceReader) {
        super(dataSourceReader);
        this.pzmapReader = pzmapReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        try {
            InputStreamReader r;
            if (this.dataSourceStream != null) {
                r = new InputStreamReader(this.dataSourceStream);
                this.setDataSourceReader(r);
                this.addToCloseReaderList(r);
            } else if (this.dataSource != null) {
                r = new FileReader(this.dataSource);
                this.setDataSourceReader(r);
                this.addToCloseReaderList(r);
            }
            boolean closeMapReader = false;
            if (this.pzmapXML != null) {
                this.pzmapReader = new FileReader(this.pzmapXML);
                closeMapReader = true;
            } else if (this.pzmapXMLStream != null) {
                this.pzmapReader = new InputStreamReader(this.pzmapXMLStream);
                closeMapReader = true;
            }
            try {
                this.setPzMetaData(MapParser.parseMap(this.pzmapReader, this));
            }
            finally {
                if (closeMapReader) {
                    this.pzmapReader.close();
                }
            }
        }
        catch (JDOMException e) {
            throw new InitialisationException(e);
        }
        catch (IOException e) {
            throw new InitialisationException(e);
        }
    }
}

