/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack.util;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import jxl.Workbook;
import jxl.format.CellFormat;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import net.sf.flatpack.DataSet;

public class ExcelTransformer {
    private DataSet ds;
    private File xlsFile;
    private String[] exportOnlyColumns;
    private String[] excludeFromExportColumns;

    public ExcelTransformer(DataSet ds, File xlsFile) {
        this.ds = ds;
        this.xlsFile = xlsFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExcelFile() throws IOException, WriteException {
        WritableWorkbook excelWrkBook = null;
        int curDsPointer = 0;
        try {
            String[] columnNames = this.ds.getColumns();
            List<String> exportOnlyColumnsList = this.exportOnlyColumns != null ? Arrays.asList(this.exportOnlyColumns) : null;
            List<String> excludeFromExportColumnsList = this.excludeFromExportColumns != null ? Arrays.asList(this.excludeFromExportColumns) : null;
            curDsPointer = this.ds.getIndex();
            this.ds.goTop();
            excelWrkBook = Workbook.createWorkbook((File)this.xlsFile);
            WritableSheet wrkSheet = excelWrkBook.createSheet("results", 0);
            WritableFont times10ptBold = new WritableFont(WritableFont.TIMES, 10, WritableFont.BOLD);
            WritableFont times10pt = new WritableFont(WritableFont.TIMES, 10, WritableFont.NO_BOLD);
            WritableCellFormat cellFormat = new WritableCellFormat(times10ptBold);
            int colOffset = 0;
            for (int i = 0; i < columnNames.length; ++i) {
                if (exportOnlyColumnsList != null && !exportOnlyColumnsList.contains(columnNames[i])) {
                    ++colOffset;
                    continue;
                }
                if (excludeFromExportColumnsList != null && excludeFromExportColumnsList.contains(columnNames[i])) {
                    ++colOffset;
                    continue;
                }
                Label xlsTextLbl = new Label(i - colOffset, 0, columnNames[i], (CellFormat)cellFormat);
                wrkSheet.addCell((WritableCell)xlsTextLbl);
            }
            cellFormat = new WritableCellFormat(times10pt);
            int row = 1;
            while (this.ds.next()) {
                if (!this.ds.isRecordID("detail")) continue;
                colOffset = 0;
                for (int i = 0; i < columnNames.length; ++i) {
                    if (exportOnlyColumnsList != null && !exportOnlyColumnsList.contains(columnNames[i])) {
                        ++colOffset;
                        continue;
                    }
                    if (excludeFromExportColumnsList != null && excludeFromExportColumnsList.contains(columnNames[i])) {
                        ++colOffset;
                        continue;
                    }
                    Label xlsTextLbl = new Label(i - colOffset, row, this.ds.getString(columnNames[i]), (CellFormat)cellFormat);
                    wrkSheet.addCell((WritableCell)xlsTextLbl);
                }
                ++row;
            }
            excelWrkBook.write();
        }
        finally {
            if (curDsPointer > -1) {
                this.ds.absolute(curDsPointer);
            }
            if (excelWrkBook != null) {
                excelWrkBook.close();
            }
        }
    }

    public void setExcludeFromExportColumns(String[] excludeFromExportColumns) {
        this.excludeFromExportColumns = excludeFromExportColumns;
    }

    public void setExportOnlyColumns(String[] exportOnlyColumns) {
        this.exportOnlyColumns = exportOnlyColumns;
    }
}

