/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import net.sf.flatpack.Parser;
import net.sf.flatpack.converter.Converter;
import net.sf.flatpack.converter.FPConvertException;
import net.sf.flatpack.structure.ColumnMetaData;
import net.sf.flatpack.util.FPException;
import net.sf.flatpack.xml.MetaData;
import net.sf.flatpack.xml.XMLRecordElement;

public final class ParserUtils {
    private ParserUtils() {
    }

    public static List splitLine(String line, char delimiter, char qualifier, int initialSize) {
        ArrayList<String> list = new ArrayList<String>(initialSize);
        if (delimiter == '\u0000') {
            list.add(line);
            return list;
        }
        if (line == null) {
            return list;
        }
        String trimmedLine = delimiter == '\t' || delimiter == ' ' ? line : line.trim();
        int size = trimmedLine.length();
        if (size == 0) {
            list.add("");
            return list;
        }
        boolean insideQualifier = false;
        char previousChar = '\u0000';
        int startBlock = 0;
        int endBlock = 0;
        boolean blockWasInQualifier = false;
        String doubleQualifier = String.valueOf(qualifier) + String.valueOf(qualifier);
        for (int i = 0; i < size; ++i) {
            char currentChar = trimmedLine.charAt(i);
            if (currentChar != delimiter && currentChar != qualifier) {
                previousChar = currentChar;
                endBlock = i + 1;
                continue;
            }
            if (currentChar == delimiter) {
                if (!insideQualifier) {
                    String trimmed = trimmedLine.substring(startBlock, endBlock > startBlock ? endBlock : startBlock + 1);
                    trimmed = !blockWasInQualifier ? trimmed.trim() : trimmed.replaceAll(doubleQualifier, String.valueOf(qualifier));
                    if (trimmed.length() == 1 && (trimmed.charAt(0) == delimiter || trimmed.charAt(0) == qualifier)) {
                        list.add("");
                    } else {
                        list.add(trimmed);
                    }
                    blockWasInQualifier = false;
                    startBlock = i + 1;
                }
            } else if (currentChar == qualifier) {
                if (!insideQualifier && previousChar != qualifier) {
                    if (previousChar == delimiter || previousChar == '\u0000' || previousChar == ' ') {
                        insideQualifier = true;
                        startBlock = i + 1;
                    } else {
                        endBlock = i + 1;
                    }
                } else {
                    if (i + 1 < size && delimiter != ' ') {
                        int start = i + 1;
                        char charToCheck = trimmedLine.charAt(start);
                        while (charToCheck == ' ' && ++start != size) {
                            charToCheck = trimmedLine.charAt(start);
                        }
                        if (charToCheck != delimiter) {
                            previousChar = currentChar;
                            endBlock = i + 1;
                            continue;
                        }
                    }
                    insideQualifier = false;
                    blockWasInQualifier = true;
                    endBlock = i;
                    if (i == size - 1) {
                        String str = trimmedLine.substring(startBlock, size - 1);
                        str = str.replaceAll(doubleQualifier, String.valueOf(qualifier));
                        list.add(str);
                        startBlock = i + 1;
                    }
                }
            }
            previousChar = currentChar;
        }
        if (startBlock < size) {
            String str = trimmedLine.substring(startBlock, size);
            str = str.replaceAll(doubleQualifier, String.valueOf(qualifier));
            if (blockWasInQualifier) {
                if (str.charAt(str.length() - 1) == qualifier) {
                    list.add(str.substring(0, str.length() - 1));
                } else {
                    list.add(str);
                }
            } else {
                list.add(str.trim());
            }
        } else if (trimmedLine.charAt(size - 1) == delimiter) {
            list.add("");
        }
        return list;
    }

    public static int getDelimiterOffset(String line, int start, char delimiter) {
        int idx = line.indexOf(delimiter, start);
        if (idx >= 0) {
            idx -= start - 1;
        }
        return idx;
    }

    public static String lTrim(String value) {
        int offset;
        if (value == null) {
            return null;
        }
        String trimmed = value;
        int maxLength = value.length();
        for (offset = 0; offset < maxLength && (value.charAt(offset) == ' ' || value.charAt(offset) == '\t'); ++offset) {
        }
        if (offset > 0) {
            trimmed = value.substring(offset);
        }
        return trimmed;
    }

    public static String lTrimKeepTabs(String value) {
        int offset;
        if (value == null) {
            return null;
        }
        String trimmed = value;
        int maxLength = value.length();
        for (offset = 0; offset < maxLength && value.charAt(offset) == ' '; ++offset) {
        }
        if (offset > 0) {
            trimmed = value.substring(offset);
        }
        return trimmed;
    }

    public static String rTrim(String value) {
        int offset;
        if (value == null) {
            return null;
        }
        String trimmed = value;
        for (offset = value.length() - 1; offset > -1 && (value.charAt(offset) == ' ' || value.charAt(offset) == '\t'); --offset) {
        }
        if (offset < value.length() - 1) {
            trimmed = value.substring(0, offset + 1);
        }
        return trimmed;
    }

    public static String trimToNull(String value) {
        if (value == null) {
            return null;
        }
        String ret = value.trim();
        return ret.length() == 0 ? null : ret;
    }

    public static String removeChar(char theChar, String theString) {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < theString.length(); ++i) {
            char currentChar = theString.charAt(i);
            if (currentChar == theChar) continue;
            s.append(currentChar);
        }
        return s.toString();
    }

    public static Map getColumnMDFromFile(String line, char delimiter, char qualifier) {
        return ParserUtils.getColumnMDFromFile(line, delimiter, qualifier, null);
    }

    public static Map getColumnMDFromFile(String line, char delimiter, char qualifier, Parser p) {
        List lineData = null;
        ArrayList<ColumnMetaData> results = new ArrayList<ColumnMetaData>();
        LinkedHashMap<String, Object> columnMD = new LinkedHashMap<String, Object>();
        lineData = ParserUtils.splitLine(line, delimiter, qualifier, 10);
        for (int i = 0; i < lineData.size(); ++i) {
            ColumnMetaData cmd = new ColumnMetaData();
            cmd.setColName((String)lineData.get(i));
            results.add(cmd);
        }
        columnMD.put("detail", results);
        columnMD.put("colIndex", ParserUtils.buidColumnIndexMap(results, p));
        return columnMD;
    }

    public static MetaData getPZMetaDataFromFile(String line, char delimiter, char qualifier, Parser p) {
        List lineData = null;
        ArrayList<ColumnMetaData> results = new ArrayList<ColumnMetaData>();
        HashSet<String> dupCheck = new HashSet<String>();
        lineData = ParserUtils.splitLine(line, delimiter, qualifier, 10);
        for (int i = 0; i < lineData.size(); ++i) {
            ColumnMetaData cmd = new ColumnMetaData();
            cmd.setColName((String)lineData.get(i));
            if (dupCheck.contains(cmd.getColName())) {
                throw new FPException("Duplicate Column Name In File: " + cmd.getColName());
            }
            results.add(cmd);
            dupCheck.add(cmd.getColName());
        }
        return new MetaData(results, ParserUtils.buidColumnIndexMap(results, p));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getColumnMDFromFile(File theFile, String delimiter, String qualifier) throws IOException {
        BufferedReader br = null;
        FileReader fr = null;
        String line = null;
        List lineData = null;
        ArrayList<ColumnMetaData> results = new ArrayList<ColumnMetaData>();
        try {
            fr = new FileReader(theFile);
            br = new BufferedReader(fr);
            while ((line = br.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                lineData = ParserUtils.splitLine(line, delimiter.charAt(0), qualifier.charAt(0), 10);
                for (int i = 0; i < lineData.size(); ++i) {
                    ColumnMetaData cmd = new ColumnMetaData();
                    cmd.setColName((String)lineData.get(i));
                    results.add(cmd);
                }
                break;
            }
        }
        finally {
            if (lineData != null) {
                lineData.clear();
            }
            if (br != null) {
                br.close();
            }
            if (fr != null) {
                fr.close();
            }
        }
        return results;
    }

    public static int findColumn(String columnName, List columnMD) {
        for (int i = 0; i < columnMD.size(); ++i) {
            ColumnMetaData cmd = (ColumnMetaData)columnMD.get(i);
            if (!cmd.getColName().equalsIgnoreCase(columnName)) continue;
            return i;
        }
        throw new NoSuchElementException("Column Name: " + columnName + " does not exist");
    }

    public static boolean isMultiLine(char[] chrArry, char delimiter, char qualifier) {
        if (chrArry[chrArry.length - 1] != qualifier) {
            boolean qualiFound = false;
            block0: for (int i = chrArry.length - 1; i >= 0; --i) {
                if (qualiFound) {
                    if (chrArry[i] == ' ') continue;
                    if (chrArry[i] == delimiter) {
                        return true;
                    }
                    qualiFound = false;
                    continue;
                }
                if (chrArry[i] == delimiter) {
                    for (int j = i - 1; j >= 0; --j) {
                        if (chrArry[j] == ' ') continue;
                        if (chrArry[j] != qualifier) continue block0;
                        return false;
                    }
                    continue;
                }
                if (chrArry[i] != qualifier) continue;
                qualiFound = true;
            }
        } else {
            for (int i = chrArry.length - 1; i >= 0; --i) {
                if (i == chrArry.length - 1 || chrArry[i] == ' ') continue;
                if (chrArry[i] == delimiter) {
                    return true;
                }
                break;
            }
        }
        return false;
    }

    public static Map calculateRecordLengths(Map columnMD) {
        HashMap recordLengths = new HashMap();
        List cmds = null;
        Iterator columnMDIt = columnMD.entrySet().iterator();
        while (columnMDIt.hasNext()) {
            Map.Entry entry = columnMDIt.next();
            cmds = entry.getKey().equals("detail") || entry.getKey().equals("colIndex") ? (List)columnMD.get("detail") : ((XMLRecordElement)entry.getValue()).getColumns();
            int recordLength = 0;
            for (int i = 0; i < cmds.size(); ++i) {
                recordLength += ((ColumnMetaData)cmds.get(i)).getColLength();
            }
            recordLengths.put(entry.getKey(), new Integer(recordLength));
        }
        return recordLengths;
    }

    public static Map calculateRecordLengths(MetaData columnMD) {
        HashMap<String, Integer> recordLengths = new HashMap<String, Integer>();
        List cmds = null;
        int recordLength = 0;
        Iterator i = columnMD.getColumnsNames().iterator();
        while (i.hasNext()) {
            recordLength += ((ColumnMetaData)i.next()).getColLength();
        }
        recordLengths.put("detail", new Integer(recordLength));
        Iterator columnMDIt = columnMD.xmlRecordIterator();
        while (columnMDIt.hasNext()) {
            Map.Entry entry = (Map.Entry)columnMDIt.next();
            cmds = ((XMLRecordElement)entry.getValue()).getColumns();
            recordLength = 0;
            for (int i2 = 0; i2 < cmds.size(); ++i2) {
                recordLength += ((ColumnMetaData)cmds.get(i2)).getColLength();
            }
            recordLengths.put((String)entry.getKey(), new Integer(recordLength));
        }
        return recordLengths;
    }

    public static String getCMDKeyForDelimitedFile(Map columnMD, List lineElements) {
        if (columnMD.size() == 1) {
            return "detail";
        }
        Iterator mapEntries = columnMD.entrySet().iterator();
        while (mapEntries.hasNext()) {
            String lineElement;
            Map.Entry entry = mapEntries.next();
            if (entry.getKey().equals("detail") || entry.getKey().equals("colIndex")) continue;
            XMLRecordElement recordXMLElement = (XMLRecordElement)entry.getValue();
            if (recordXMLElement.getElementCount() > 0 && recordXMLElement.getElementCount() == lineElements.size()) {
                return (String)entry.getKey();
            }
            if (recordXMLElement.getElementNumber() > lineElements.size() || !(lineElement = (String)lineElements.get(recordXMLElement.getElementNumber() - 1)).equals(recordXMLElement.getIndicator())) continue;
            return (String)entry.getKey();
        }
        return "detail";
    }

    public static String getCMDKeyForDelimitedFile(MetaData columnMD, List lineElements) {
        if (!columnMD.isAnyRecordFormatSpecified()) {
            return "detail";
        }
        Iterator mapEntries = columnMD.xmlRecordIterator();
        while (mapEntries.hasNext()) {
            String lineElement;
            Map.Entry entry = (Map.Entry)mapEntries.next();
            XMLRecordElement recordXMLElement = (XMLRecordElement)entry.getValue();
            if (recordXMLElement.getElementCount() > 0 && recordXMLElement.getElementCount() == lineElements.size()) {
                return (String)entry.getKey();
            }
            if (recordXMLElement.getElementNumber() > lineElements.size() || !(lineElement = (String)lineElements.get(recordXMLElement.getElementNumber() - 1)).equals(recordXMLElement.getIndicator())) continue;
            return (String)entry.getKey();
        }
        return "detail";
    }

    public static List getColumnMetaData(String key, Map columnMD) {
        if (key == null || key.equals("detail") || key.equals("colIndex")) {
            return (List)columnMD.get("detail");
        }
        return ((XMLRecordElement)columnMD.get(key)).getColumns();
    }

    public static List getColumnMetaData(String key, MetaData columnMD) {
        if (key == null || key.equals("detail") || key.equals("colIndex")) {
            return columnMD.getColumnsNames();
        }
        return columnMD.getListColumnsForRecord(key);
    }

    public static int getColumnIndex(String key, Map columnMD, String colName, Parser p) {
        Map map;
        Integer i;
        int idx = -1;
        String column = colName;
        if (p != null && !p.isColumnNamesCaseSensitive()) {
            column = colName.toLowerCase(Locale.getDefault());
        }
        if (key != null && !key.equals("detail") && !key.equals("colIndex")) {
            idx = ((XMLRecordElement)columnMD.get(key)).getColumnIndex(column);
        } else if ((key == null || key.equals("detail")) && (i = (Integer)(map = (Map)columnMD.get("colIndex")).get(column)) != null) {
            idx = i;
        }
        if (idx < 0) {
            throw new NoSuchElementException("Column " + colName + " does not exist, check case/spelling. key:" + key);
        }
        return idx;
    }

    public static int getColumnIndex(String key, MetaData columnMD, String colName, Parser p) {
        int idx = -1;
        String column = colName;
        if (p != null && !p.isColumnNamesCaseSensitive()) {
            column = colName.toLowerCase(Locale.getDefault());
        }
        if ((idx = columnMD.getColumnIndex(key, column)) < 0) {
            throw new NoSuchElementException("Column [" + column + "] does not exist, check case/spelling. key:" + key);
        }
        return idx;
    }

    public static int getColumnIndex(String key, Map columnMD, String colName) {
        return ParserUtils.getColumnIndex(key, columnMD, colName, null);
    }

    public static InputStream createInputStream(File file) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("null not allowed");
        }
        return new FileInputStream(file);
    }

    public static void closeReader(Reader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void closeReader(InputStream reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String padding(int repeat, char padChar) {
        if (repeat < 0) {
            throw new IndexOutOfBoundsException("Cannot pad a negative amount: " + repeat);
        }
        char[] buf = new char[repeat];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = padChar;
        }
        return new String(buf);
    }

    public static Map buidColumnIndexMap(List columns, Parser p) {
        HashMap<String, Integer> map = null;
        if (columns != null && !columns.isEmpty()) {
            map = new HashMap<String, Integer>();
            int idx = 0;
            Iterator it = columns.iterator();
            while (it.hasNext()) {
                ColumnMetaData meta = (ColumnMetaData)it.next();
                String colName = meta.getColName();
                if (p != null && !p.isColumnNamesCaseSensitive()) {
                    colName = colName.toLowerCase(Locale.getDefault());
                }
                map.put(colName, new Integer(idx));
                ++idx;
            }
        }
        return map;
    }

    public static Map buidColumnIndexMap(List columns) {
        return ParserUtils.buidColumnIndexMap(columns, null);
    }

    public static String stripNonLongChars(String value) {
        char c;
        StringBuffer newString = new StringBuffer();
        for (int i = 0; i < value.length() && (c = value.charAt(i)) != '.'; ++i) {
            if ((c < '0' || c > '9') && c != '-') continue;
            newString.append(c);
        }
        int sLen = newString.length();
        String s = newString.toString();
        if (sLen == 0 || sLen == 1 && s.equals("-")) {
            return "0";
        }
        return newString.toString();
    }

    public static String stripNonDoubleChars(String value) {
        StringBuffer newString = new StringBuffer();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if ((c < '0' || c > '9') && c != '-' && c != '.') continue;
            newString.append(c);
        }
        int sLen = newString.length();
        String s = newString.toString();
        if (sLen == 0 || sLen == 1 && s.equals(".") || sLen == 1 && s.equals("-")) {
            return "0";
        }
        return newString.toString();
    }

    public static Properties loadConvertProperties() throws IOException {
        Properties pzConvertProps = new Properties();
        URL url = ParserUtils.class.getClassLoader().getResource("fpconvert.properties");
        pzConvertProps.load(url.openStream());
        return pzConvertProps;
    }

    public static boolean isListElementsEmpty(List l) {
        Iterator it = l.iterator();
        while (it.hasNext()) {
            String s = (String)it.next();
            if (s == null || s.trim().length() <= 0) continue;
            return false;
        }
        return true;
    }

    public static Object runPzConverter(Properties classXref, String value, Class typeToReturn) {
        String sConverter = classXref.getProperty(typeToReturn.getName());
        if (sConverter == null) {
            throw new FPConvertException(typeToReturn.getName() + " is not registered in pzconvert.properties");
        }
        try {
            Converter pzconverter = (Converter)Class.forName(sConverter).newInstance();
            return pzconverter.convertValue(value);
        }
        catch (IllegalAccessException ex) {
            throw new FPConvertException(ex);
        }
        catch (InstantiationException ex) {
            throw new FPConvertException(ex);
        }
        catch (ClassNotFoundException ex) {
            throw new FPConvertException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List buildMDFromSQLTable(Connection con, String dataDefinition) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<ColumnMetaData> cmds = new ArrayList<ColumnMetaData>();
        try {
            String sql = "SELECT * FROM DATAFILE INNER JOIN DATASTRUCTURE ON DATAFILE.DATAFILE_NO = DATASTRUCTURE.DATAFILE_NO WHERE DATAFILE.DATAFILE_DESC = ? ORDER BY DATASTRUCTURE_COL_ORDER";
            stmt = con.prepareStatement("SELECT * FROM DATAFILE INNER JOIN DATASTRUCTURE ON DATAFILE.DATAFILE_NO = DATASTRUCTURE.DATAFILE_NO WHERE DATAFILE.DATAFILE_DESC = ? ORDER BY DATASTRUCTURE_COL_ORDER");
            stmt.setString(1, dataDefinition);
            rs = stmt.executeQuery();
            int recPosition = 1;
            while (rs.next()) {
                ColumnMetaData column = new ColumnMetaData();
                column.setColName(rs.getString("DATASTRUCTURE_COLUMN"));
                column.setColLength(rs.getInt("DATASTRUCTURE_LENGTH"));
                column.setStartPosition(recPosition);
                column.setEndPosition(recPosition + (rs.getInt("DATASTRUCTURE_LENGTH") - 1));
                recPosition += rs.getInt("DATASTRUCTURE_LENGTH");
                cmds.add(column);
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return cmds;
    }
}

