/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.http;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URI;
import org.apache.activemq.command.ShutdownInfo;
import org.apache.activemq.transport.FutureResponse;
import org.apache.activemq.transport.http.HttpTransportSupport;
import org.apache.activemq.transport.util.TextWireFormat;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.IdGenerator;
import org.apache.activemq.util.ServiceStopper;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.message.AbstractHttpMessage;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientTransport
extends HttpTransportSupport {
    public static final int MAX_CLIENT_TIMEOUT = 30000;
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientTransport.class);
    private static final IdGenerator CLIENT_ID_GENERATOR = new IdGenerator();
    private HttpClient sendHttpClient;
    private HttpClient receiveHttpClient;
    private final String clientID = CLIENT_ID_GENERATOR.generateId();
    private boolean trace;
    private HttpGet httpMethod;
    private volatile int receiveCounter;
    private int soTimeout = 30000;

    public HttpClientTransport(TextWireFormat wireFormat, URI remoteUrl) {
        super(wireFormat, remoteUrl);
    }

    public FutureResponse asyncRequest(Object command) throws IOException {
        return null;
    }

    public void oneway(Object command) throws IOException {
        if (this.isStopped()) {
            throw new IOException("stopped.");
        }
        HttpPost httpMethod = new HttpPost(this.getRemoteUrl().toString());
        this.configureMethod((AbstractHttpMessage)httpMethod);
        String data = this.getTextWireFormat().marshalText(command);
        byte[] bytes = data.getBytes("UTF-8");
        ByteArrayEntity entity = new ByteArrayEntity(bytes);
        httpMethod.setEntity((HttpEntity)entity);
        HttpClient client = null;
        HttpResponse answer = null;
        try {
            client = this.getSendHttpClient();
            HttpParams params = client.getParams();
            HttpConnectionParams.setSoTimeout((HttpParams)params, (int)this.soTimeout);
            answer = client.execute((HttpUriRequest)httpMethod);
            int status = answer.getStatusLine().getStatusCode();
            if (status != 200) {
                throw new IOException("Failed to post command: " + command + " as response was: " + answer);
            }
            if (command instanceof ShutdownInfo) {
                try {
                    this.stop();
                }
                catch (Exception e) {
                    LOG.warn("Error trying to stop HTTP client: " + e, (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            throw IOExceptionSupport.create((String)("Could not post command: " + command + " due to: " + e), (Exception)e);
        }
        finally {
            if (answer != null) {
                EntityUtils.consume((HttpEntity)answer.getEntity());
            }
        }
    }

    public Object request(Object command) throws IOException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        LOG.trace("HTTP GET consumer thread starting: " + (Object)((Object)this));
        HttpClient httpClient = this.getReceiveHttpClient();
        URI remoteUrl = this.getRemoteUrl();
        while (!this.isStopped() && !this.isStopping()) {
            this.httpMethod = new HttpGet(remoteUrl.toString());
            this.configureMethod((AbstractHttpMessage)this.httpMethod);
            HttpResponse answer = null;
            try {
                answer = httpClient.execute((HttpUriRequest)this.httpMethod);
                int status = answer.getStatusLine().getStatusCode();
                if (status != 200) {
                    if (status == 408) {
                        LOG.debug("GET timed out");
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            this.onException(new InterruptedIOException());
                            if (answer == null) break;
                            try {
                                EntityUtils.consume((HttpEntity)answer.getEntity());
                            }
                            catch (IOException e2) {}
                            break;
                        }
                    }
                    this.onException(new IOException("Failed to perform GET on: " + remoteUrl + " as response was: " + answer));
                    break;
                }
                ++this.receiveCounter;
                DataInputStream stream = new DataInputStream(answer.getEntity().getContent());
                Object command = this.getTextWireFormat().unmarshal(stream);
                if (command == null) {
                    LOG.debug("Received null command from url: " + remoteUrl);
                } else {
                    this.doConsume(command);
                }
                stream.close();
            }
            catch (IOException e) {
                this.onException(IOExceptionSupport.create((String)("Failed to perform GET on: " + remoteUrl + " Reason: " + e.getMessage()), (Exception)e));
                break;
            }
            finally {
                if (answer == null) continue;
                try {
                    EntityUtils.consume((HttpEntity)answer.getEntity());
                }
                catch (IOException e) {}
            }
        }
    }

    public HttpClient getSendHttpClient() {
        if (this.sendHttpClient == null) {
            this.sendHttpClient = this.createHttpClient();
        }
        return this.sendHttpClient;
    }

    public void setSendHttpClient(HttpClient sendHttpClient) {
        this.sendHttpClient = sendHttpClient;
    }

    public HttpClient getReceiveHttpClient() {
        if (this.receiveHttpClient == null) {
            this.receiveHttpClient = this.createHttpClient();
        }
        return this.receiveHttpClient;
    }

    public void setReceiveHttpClient(HttpClient receiveHttpClient) {
        this.receiveHttpClient = receiveHttpClient;
    }

    protected void doStart() throws Exception {
        LOG.trace("HTTP GET consumer thread starting: " + (Object)((Object)this));
        HttpClient httpClient = this.getReceiveHttpClient();
        URI remoteUrl = this.getRemoteUrl();
        HttpHead httpMethod = new HttpHead(remoteUrl.toString());
        this.configureMethod((AbstractHttpMessage)httpMethod);
        BasicResponseHandler handler = new BasicResponseHandler();
        try {
            httpClient.execute((HttpUriRequest)httpMethod, (ResponseHandler)handler);
        }
        catch (Exception e) {
            throw new IOException("Failed to perform GET on: " + remoteUrl + " as response was: " + e.getMessage());
        }
        super.doStart();
    }

    protected void doStop(ServiceStopper stopper) throws Exception {
        if (this.httpMethod != null) {
            this.httpMethod.abort();
        }
    }

    protected HttpClient createHttpClient() {
        DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)new ThreadSafeClientConnManager());
        if (this.getProxyHost() != null) {
            HttpHost proxy = new HttpHost(this.getProxyHost(), this.getProxyPort());
            client.getParams().setParameter("http.route.default-proxy", (Object)proxy);
            if (this.getProxyUser() != null && this.getProxyPassword() != null) {
                client.getCredentialsProvider().setCredentials(new AuthScope(this.getProxyHost(), this.getProxyPort()), (Credentials)new UsernamePasswordCredentials(this.getProxyUser(), this.getProxyPassword()));
            }
        }
        return client;
    }

    protected void configureMethod(AbstractHttpMessage method) {
        method.setHeader("clientID", this.clientID);
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public int getReceiveCounter() {
        return this.receiveCounter;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }
}

