/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.samples.wsdl_first;

import javax.jws.WebService;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import javax.xml.ws.Holder;
import org.apache.servicemix.samples.wsdl_first.Person;
import org.apache.servicemix.samples.wsdl_first.PersonEntity;
import org.apache.servicemix.samples.wsdl_first.types.UnknownPersonFault;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebService(serviceName="PersonService", targetNamespace="http://servicemix.apache.org/samples/wsdl-first", endpointInterface="org.apache.servicemix.samples.wsdl_first.Person")
public class PersonImpl
implements Person {
    private EntityManagerFactory entityManagerFactory;

    public PersonImpl(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
        EntityManager entityManager = entityManagerFactory.createEntityManager();
        entityManager.getTransaction().begin();
        PersonEntity personEntity = new PersonEntity();
        personEntity.setPersonId("ffang");
        personEntity.setSsn("000-000-0000");
        personEntity.setName("Freeman Fang");
        entityManager.persist((Object)personEntity);
        PersonEntity personEntity2 = new PersonEntity();
        personEntity2.setPersonId("gnodet");
        personEntity2.setSsn("111-111-1111");
        personEntity2.setName("Guillaume Nodet");
        entityManager.persist((Object)personEntity2);
        entityManager.getTransaction().commit();
        entityManager.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getPerson(Holder<String> personId, Holder<String> ssn, Holder<String> name) throws org.apache.servicemix.samples.wsdl_first.UnknownPersonFault {
        if (personId.value == null || ((String)personId.value).length() == 0) {
            UnknownPersonFault fault = new UnknownPersonFault();
            fault.setPersonId((String)personId.value);
            throw new org.apache.servicemix.samples.wsdl_first.UnknownPersonFault(null, fault);
        }
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            Query q = entityManager.createQuery("select p from person p where p.personId = :name");
            q.setParameter("name", personId.value);
            PersonEntity p = (PersonEntity)q.getSingleResult();
            entityManager.close();
            ssn.value = p.getSsn();
            name.value = p.getName();
        }
        finally {
            if (cl != null) {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
    }

    public void setEntityManagerFactory(EntityManagerFactory emf) {
        this.entityManagerFactory = emf;
    }
}

