/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.jdbc.JdbcEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.IntrospectionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcProducer
extends DefaultProducer {
    private static final transient Logger LOG = LoggerFactory.getLogger(JdbcProducer.class);
    private DataSource dataSource;
    private int readSize;
    private Map<String, Object> parameters;

    public JdbcProducer(JdbcEndpoint endpoint, DataSource dataSource, int readSize, Map<String, Object> parameters) throws Exception {
        super((Endpoint)endpoint);
        this.dataSource = dataSource;
        this.readSize = readSize;
        this.parameters = parameters;
    }

    public JdbcEndpoint getEndpoint() {
        return (JdbcEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        if (this.getEndpoint().isResetAutoCommit()) {
            this.processingSqlBySettingAutoCommit(exchange);
        } else {
            this.processingSqlWithoutSettingAutoCommit(exchange);
        }
        exchange.getOut().getHeaders().putAll(exchange.getIn().getHeaders());
    }

    private void processingSqlBySettingAutoCommit(Exchange exchange) throws Exception {
        String sql = (String)exchange.getIn().getBody(String.class);
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        Boolean autoCommit = null;
        try {
            conn = this.dataSource.getConnection();
            autoCommit = conn.getAutoCommit();
            if (autoCommit.booleanValue()) {
                conn.setAutoCommit(false);
            }
            stmt = conn.createStatement();
            if (this.parameters != null && !this.parameters.isEmpty()) {
                IntrospectionSupport.setProperties((Object)stmt, this.parameters);
            }
            LOG.debug("Executing JDBC statement: {}", (Object)sql);
            if (stmt.execute(sql)) {
                rs = stmt.getResultSet();
                this.setResultSet(exchange, rs);
            } else {
                int updateCount = stmt.getUpdateCount();
                exchange.getOut().setHeader("CamelJdbcUpdateCount", (Object)updateCount);
            }
            conn.commit();
            this.closeQuietly(rs);
            this.closeQuietly(stmt);
            this.resetAutoCommit(conn, autoCommit);
            this.closeQuietly(conn);
        }
        catch (Exception e) {
            try {
                try {
                    if (conn != null) {
                        conn.rollback();
                    }
                }
                catch (SQLException sqle) {
                    LOG.warn("Error on jdbc component rollback: " + sqle, (Throwable)sqle);
                }
                throw e;
            }
            catch (Throwable throwable) {
                this.closeQuietly(rs);
                this.closeQuietly(stmt);
                this.resetAutoCommit(conn, autoCommit);
                this.closeQuietly(conn);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processingSqlWithoutSettingAutoCommit(Exchange exchange) throws Exception {
        String sql = (String)exchange.getIn().getBody(String.class);
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.dataSource.getConnection();
            stmt = conn.createStatement();
            if (this.parameters != null && !this.parameters.isEmpty()) {
                IntrospectionSupport.setProperties((Object)stmt, this.parameters);
            }
            LOG.debug("Executing JDBC statement: {}", (Object)sql);
            if (stmt.execute(sql)) {
                rs = stmt.getResultSet();
                this.setResultSet(exchange, rs);
            } else {
                int updateCount = stmt.getUpdateCount();
                exchange.getOut().setHeader("CamelJdbcUpdateCount", (Object)updateCount);
            }
            this.closeQuietly(rs);
            this.closeQuietly(stmt);
            this.closeQuietly(conn);
        }
        catch (Throwable throwable) {
            this.closeQuietly(rs);
            this.closeQuietly(stmt);
            this.closeQuietly(conn);
            throw throwable;
        }
    }

    private void closeQuietly(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sqle) {
                LOG.warn("Error by closing result set: " + sqle, (Throwable)sqle);
            }
        }
    }

    private void closeQuietly(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sqle) {
                LOG.warn("Error by closing statement: " + sqle, (Throwable)sqle);
            }
        }
    }

    private void resetAutoCommit(Connection con, Boolean autoCommit) {
        if (con != null && autoCommit != null) {
            try {
                con.setAutoCommit(autoCommit);
            }
            catch (SQLException sqle) {
                LOG.warn("Error by resetting auto commit to its original value: " + sqle, (Throwable)sqle);
            }
        }
    }

    private void closeQuietly(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException sqle) {
                LOG.warn("Error by closing connection: " + sqle, (Throwable)sqle);
            }
        }
    }

    protected void setResultSet(Exchange exchange, ResultSet rs) throws SQLException {
        int rowNumber;
        ResultSetMetaData meta = rs.getMetaData();
        boolean jdbc4 = this.getEndpoint().isUseJDBC4ColumnNameAndLabelSemantics();
        int count = meta.getColumnCount();
        ArrayList data = new ArrayList();
        for (rowNumber = 0; rs.next() && (this.readSize == 0 || rowNumber < this.readSize); ++rowNumber) {
            LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
            for (int i = 0; i < count; ++i) {
                String columnName;
                int columnNumber = i + 1;
                if (jdbc4) {
                    columnName = meta.getColumnLabel(columnNumber);
                } else {
                    try {
                        columnName = meta.getColumnLabel(columnNumber);
                    }
                    catch (SQLException e) {
                        columnName = meta.getColumnName(columnNumber);
                    }
                }
                row.put(columnName, rs.getObject(columnNumber));
            }
            data.add(row);
        }
        exchange.getOut().setHeader("CamelJdbcRowCount", (Object)rowNumber);
        exchange.getOut().setBody(data);
    }
}

