/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.savvis.vpdc.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.location.Iso3166;
import org.jclouds.location.Provider;
import org.jclouds.savvis.vpdc.VPDCClient;
import org.jclouds.savvis.vpdc.domain.Network;
import org.jclouds.savvis.vpdc.domain.Org;
import org.jclouds.savvis.vpdc.domain.VDC;

@Singleton
public class NetworkToLocation
implements Function<Network, Location> {
    public static final Pattern netPattern = Pattern.compile(".*org/([0-9.]+)/vdc/([0-9.]+)/network/(.*)$");
    private final String providerName;
    private final URI endpoint;
    private final Set<String> isoCodes;
    private VPDCClient client;

    @Inject
    public NetworkToLocation(@Iso3166 Set<String> isoCodes, @Provider String providerName, @Provider URI endpoint, VPDCClient client) {
        this.providerName = (String)Preconditions.checkNotNull((Object)providerName, (Object)"providerName");
        this.endpoint = (URI)Preconditions.checkNotNull((Object)endpoint, (Object)"endpoint");
        this.isoCodes = (Set)Preconditions.checkNotNull(isoCodes, (Object)"isoCodes");
        this.client = (VPDCClient)Preconditions.checkNotNull((Object)client, (Object)"client");
    }

    public Location apply(Network from) {
        Matcher matcher = netPattern.matcher(from.getHref().toASCIIString());
        if (matcher.find()) {
            Location provider = new LocationBuilder().scope(LocationScope.PROVIDER).id(this.providerName).description(this.endpoint.toASCIIString()).iso3166Codes(this.isoCodes).build();
            Org org = this.client.getBrowsingClient().getOrg(matcher.group(1));
            Location orgLocation = new LocationBuilder().scope(LocationScope.REGION).id(org.getId()).description(org.getDescription()).parent(provider).build();
            VDC vdc = this.client.getBrowsingClient().getVDCInOrg(org.getId(), matcher.group(2));
            Location vdcLocation = new LocationBuilder().scope(LocationScope.ZONE).id(vdc.getId()).description(vdc.getDescription()).parent(orgLocation).build();
            return new LocationBuilder().scope(LocationScope.NETWORK).id(from.getId()).description(from.getName()).parent(vdcLocation).build();
        }
        throw new IllegalArgumentException("network unparsable: " + from);
    }
}

