/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.savvis.vpdc.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.FindResourceInSet;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.CIMOperatingSystem;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Location;
import org.jclouds.ovf.Network;
import org.jclouds.ovf.OperatingSystemSection;
import org.jclouds.savvis.vpdc.domain.VM;
import org.jclouds.savvis.vpdc.util.Utils;
import org.jclouds.util.InetAddresses2;

@Singleton
public class VMToNodeMetadata
implements Function<VM, NodeMetadata> {
    public static final Map<VM.Status, NodeState> VAPPSTATUS_TO_NODESTATE = ImmutableMap.builder().put((Object)VM.Status.OFF, (Object)NodeState.SUSPENDED).put((Object)VM.Status.ON, (Object)NodeState.RUNNING).put((Object)VM.Status.RESOLVED, (Object)NodeState.PENDING).put((Object)VM.Status.UNRECOGNIZED, (Object)NodeState.UNRECOGNIZED).put((Object)VM.Status.UNKNOWN, (Object)NodeState.UNRECOGNIZED).put((Object)VM.Status.SUSPENDED, (Object)NodeState.SUSPENDED).put((Object)VM.Status.UNRESOLVED, (Object)NodeState.PENDING).build();
    private final FindLocationForVM findLocationForVM;

    @Inject
    VMToNodeMetadata(FindLocationForVM findLocationForVM) {
        this.findLocationForVM = (FindLocationForVM)((Object)Preconditions.checkNotNull((Object)((Object)findLocationForVM), (Object)"findLocationForVM"));
    }

    public NodeMetadata apply(VM from) {
        NodeMetadataBuilder builder = new NodeMetadataBuilder();
        builder.ids(from.getHref().toASCIIString());
        builder.name(from.getName());
        builder.location((Location)this.findLocationForVM.apply(from));
        builder.group(ComputeServiceUtils.parseGroupFromName((String)from.getName()));
        try {
            builder.operatingSystem((OperatingSystem)CIMOperatingSystem.toComputeOs((OperatingSystemSection)from.getOperatingSystemSection()));
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        builder.state(VAPPSTATUS_TO_NODESTATE.get((Object)from.getStatus()));
        Set<String> addresses = Utils.getIpsFromVM(from);
        builder.publicAddresses(Iterables.filter(addresses, (Predicate)Predicates.not((Predicate)InetAddresses2.IsPrivateIPAddress.INSTANCE)));
        builder.privateAddresses(Iterables.filter(addresses, (Predicate)InetAddresses2.IsPrivateIPAddress.INSTANCE));
        return builder.build();
    }

    @Singleton
    public static class FindLocationForVM
    extends FindResourceInSet<VM, Location> {
        @Inject
        public FindLocationForVM(@Memoized Supplier<Set<? extends Location>> hardware) {
            super(hardware);
        }

        public boolean matches(VM from, Location input) {
            return input.getId().equals(((Network)Iterables.get((Iterable)from.getNetworkSection().getNetworks(), (int)0)).getName());
        }
    }
}

